/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.util.Arrays;
import org.refcodes.audio.MonoSample;
import org.refcodes.audio.MonoSampleBuilder;

public class MonoSampleBuilderImpl
implements MonoSampleBuilder {
    private double _timeStamp = -1.0;
    private int _sampligRate = -1;
    private double[] _sampleData = new double[1];
    private long _index = -1L;

    public MonoSampleBuilderImpl(MonoSample aSample) {
        this._index = aSample.getIndex();
        this._timeStamp = aSample.getTimeStamp();
        this._sampligRate = aSample.getSamplingRate();
        if (aSample.getSampleData() != null) {
            this._sampleData = Arrays.copyOf(aSample.getSampleData(), aSample.getChannelCount());
        }
    }

    public MonoSampleBuilderImpl(double aSample) {
        this._sampleData[0] = aSample;
    }

    public MonoSampleBuilderImpl(double aTimeMillis, double aSample) {
        this._timeStamp = aTimeMillis;
        this._sampleData[0] = aSample;
    }

    public MonoSampleBuilderImpl(double aTimeMillis, double aSample, int aSamplingRate) {
        this._timeStamp = aTimeMillis;
        this._sampleData[0] = aSample;
        this._sampligRate = aSamplingRate;
    }

    public MonoSampleBuilderImpl(double aSample, int aSamplingRate) {
        this._sampleData[0] = aSample;
        this._sampligRate = aSamplingRate;
    }

    public MonoSampleBuilderImpl(long aIndex, double aSample) {
        this._index = aIndex;
        this._sampleData[0] = aSample;
    }

    public MonoSampleBuilderImpl(long aIndex, double aSample, int aSamplingRate) {
        this._index = aIndex;
        this._sampleData[0] = aSample;
        this._sampligRate = aSamplingRate;
    }

    public MonoSampleBuilderImpl(long aIndex, double aTimeMillis, double aSample) {
        this._index = aIndex;
        this._timeStamp = aTimeMillis;
        this._sampleData[0] = aSample;
    }

    public MonoSampleBuilderImpl(long aIndex, double aTimeMillis, double aSample, int aSamplingRate) {
        this._index = aIndex;
        this._timeStamp = aTimeMillis;
        this._sampleData[0] = aSample;
        this._sampligRate = aSamplingRate;
    }

    public MonoSampleBuilderImpl(long aIndex, int aSamplingRate) {
        this._index = aIndex;
        this._sampligRate = aSamplingRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMonoData(double aSampleData) {
        if (this._sampleData == null || this._sampleData.length != 1) {
            MonoSampleBuilderImpl monoSampleBuilderImpl = this;
            synchronized (monoSampleBuilderImpl) {
                if (this._sampleData == null || this._sampleData.length != 1) {
                    this._sampleData = new double[1];
                }
            }
        }
        this._sampleData[0] = aSampleData;
    }

    @Override
    public double[] getSampleData() {
        return this._sampleData;
    }

    @Override
    public double getTimeStamp() {
        return this._timeStamp;
    }

    @Override
    public int getSamplingRate() {
        return this._sampligRate;
    }

    public long getIndex() {
        return this._index;
    }

    public void setIndex(long aIndex) {
        this._index = aIndex;
    }

    public void increaseIndex() {
        ++this._index;
    }

    public void decreaseIndex() {
        --this._index;
    }

    @Override
    public void setTimeStamp(double aTimeMillis) {
        this._timeStamp = aTimeMillis;
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        this._sampligRate = aSamplingRate;
    }

    public String toString() {
        return "MonoSampleBuilderImpl [index=" + this.getIndex() + ", timeStamp=" + this.getTimeStamp() + ", sampleData=" + this.getMonoData() + ", sampligRate=" + this.getSamplingRate();
    }
}

