/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.refcodes.audio.AbstractSvgSampleWriter;
import org.refcodes.audio.MonoSample;
import org.refcodes.audio.MonoSampleBuilder;
import org.refcodes.audio.MonoSampleBuilderImpl;
import org.refcodes.audio.MonoSampleWriter;
import org.refcodes.audio.SamplingRate;

public class SvgMonoSampleWriter
extends AbstractSvgSampleWriter<MonoSample, SvgMonoSampleWriter>
implements MonoSampleWriter<SvgMonoSampleWriter> {
    private static final int Y_SCALE_FACTOR = 500;
    private MonoSampleBuilder _soundSample = new MonoSampleBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());
    private boolean _hasHeader = false;
    private boolean _isFirst = true;

    public SvgMonoSampleWriter(File aFile) throws FileNotFoundException {
        super(aFile);
    }

    public SvgMonoSampleWriter(OutputStream aOutputStream) {
        super(aOutputStream);
    }

    public SvgMonoSampleWriter(PrintStream aPrintStream) {
        super(aPrintStream);
    }

    @Override
    public void writeNext(double aSampleData) {
        this._soundSample.setMonoData(aSampleData);
        this._soundSample.updateTimeStamp();
        this.writeNext(this._soundSample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNext(MonoSample aSample) {
        if (!this._hasHeader) {
            SvgMonoSampleWriter svgMonoSampleWriter = this;
            synchronized (svgMonoSampleWriter) {
                if (!this._hasHeader) {
                    this.writeSvgHeader();
                    this._printStream.print("\t<polyline points=\"");
                    this._hasHeader = true;
                }
            }
        }
        if (aSample != this._soundSample) {
            this._soundSample.setMonoData(aSample.getMonoData());
            if (aSample.getSamplingRate() != -1 && aSample.getSamplingRate() != this._soundSample.getSamplingRate()) {
                this._soundSample.setSamplingRate(aSample.getSamplingRate());
            }
            if (aSample.getIndex() != -1L) {
                this._soundSample.setIndex(aSample.getIndex());
            }
            if (aSample.getTimeStamp() != -1.0) {
                this._soundSample.setTimeStamp(aSample.getTimeStamp());
            }
        }
        if (!this._isFirst) {
            this._printStream.print(" " + SvgMonoSampleWriter.toString(this._soundSample.getIndex()) + "," + SvgMonoSampleWriter.toString(this.toYCoordinate(this._soundSample.getMonoData(), 500.0)));
        } else {
            this._printStream.print(SvgMonoSampleWriter.toString(this._soundSample.getIndex()) + "," + SvgMonoSampleWriter.toString(this.toYCoordinate(this._soundSample.getMonoData(), 500.0)));
            this._isFirst = false;
        }
        this._soundSample.increaseIndex();
    }

    @Override
    public void close() throws IOException {
        this._printStream.println("\" style=\"fill:none;stroke:black;stroke-width:1\" >");
        this._printStream.println("\t\t<title>Mono</title>");
        this._printStream.println("\t</polyline>");
        super.close();
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        if (aSamplingRate != -1 && aSamplingRate != this._soundSample.getSamplingRate()) {
            this._soundSample.setSamplingRate(aSamplingRate);
        }
    }

    @Override
    public SvgMonoSampleWriter withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return this;
    }
}

