/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.audio.AbstractWavSampleWriter;
import org.refcodes.audio.BitsPerSample;
import org.refcodes.audio.MonoSample;
import org.refcodes.audio.MonoSampleBuilder;
import org.refcodes.audio.MonoSampleBuilderImpl;
import org.refcodes.audio.MonoSampleWriter;
import org.refcodes.audio.SamplingRate;
import org.refcodes.numerical.NumericalUtility;

public class WavMonoSampleWriter
extends AbstractWavSampleWriter<MonoSample, WavMonoSampleWriter>
implements MonoSampleWriter<WavMonoSampleWriter> {
    private MonoSampleBuilder _soundSample = new MonoSampleBuilderImpl(0L, SamplingRate.AUDIO_CD.getSamplesPerSecond());
    private boolean _hasHeader = false;

    public WavMonoSampleWriter(File aFile) throws FileNotFoundException {
        super(aFile);
    }

    public WavMonoSampleWriter(OutputStream aOutputStream) {
        super(aOutputStream);
    }

    @Override
    public WavMonoSampleWriter withBitsPerSample(BitsPerSample aBitsPerSample) {
        this.setBitsPerSample(aBitsPerSample);
        return this;
    }

    @Override
    public void writeNext(double aSampleData) throws IOException {
        this._soundSample.setMonoData(aSampleData);
        this._soundSample.updateTimeStamp();
        this.writeNext(this._soundSample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNext(MonoSample aSample) throws IOException {
        if (!this._hasHeader) {
            WavMonoSampleWriter wavMonoSampleWriter = this;
            synchronized (wavMonoSampleWriter) {
                if (!this._hasHeader) {
                    if (aSample.getSamplingRate() > 0) {
                        this.setSamplingRate(aSample.getSamplingRate());
                    }
                    this.writeHeader(this.getSamplingRate(), 1);
                    this._hasHeader = true;
                }
            }
        }
        double theValue = this.toWavSample(aSample.getMonoData());
        byte[] eBytes = NumericalUtility.toLittleEndianBytes((long)((long)theValue), (int)this.getBitsPerSample().getByteCount());
        this._outputStream.write(eBytes);
        this._soundSample.increaseIndex();
    }

    @Override
    public int getSamplingRate() {
        return this._soundSample.getSamplingRate();
    }

    @Override
    public void setSamplingRate(int aSamplingRate) {
        if (aSamplingRate != -1 && aSamplingRate != this._soundSample.getSamplingRate()) {
            this._soundSample.setSamplingRate(aSamplingRate);
        }
    }

    @Override
    public WavMonoSampleWriter withSamplingRate(int aSamplingRate) {
        this.setSamplingRate(aSamplingRate);
        return this;
    }
}

