/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.boulderdash;

import org.refcodes.boulderdash.BoulderDashBoard;
import org.refcodes.boulderdash.BoulderDashBoardImpl;
import org.refcodes.boulderdash.BoulderDashPlayer;
import org.refcodes.boulderdash.BoulderDashPlayerFactoryImpl;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.CheckerboardImpl;
import org.refcodes.component.InitializeException;
import org.refcodes.data.ext.boulderdash.BoulderDashCaveMap;
import org.refcodes.data.ext.boulderdash.BoulderDashCaveMapFactory;
import org.refcodes.data.ext.boulderdash.BoulderDashStatus;

public class BoulderDashAutomaton
extends BoulderDashBoardImpl
implements BoulderDashBoard,
Runnable {
    public BoulderDashAutomaton(BoulderDashCaveMap aCaveMap) throws InitializeException {
        this(new BoulderDashCaveMapFactory().createInstance(aCaveMap));
    }

    public BoulderDashAutomaton(String[] aCaveMap) throws InitializeException {
        super((Checkerboard<BoulderDashPlayer, BoulderDashStatus>)new CheckerboardImpl().withGridDimension(aCaveMap[0].length(), aCaveMap.length));
        BoulderDashPlayerFactoryImpl theFactory = new BoulderDashPlayerFactoryImpl();
        for (int y = 0; y < aCaveMap.length; ++y) {
            for (int x = 0; x < aCaveMap[0].length(); ++x) {
                char eChar = this.atPosition(aCaveMap, y, x);
                if (eChar == ' ') continue;
                this.putPlayer((BoulderDashPlayer)((BoulderDashPlayer)((BoulderDashPlayer)theFactory.createInstance(BoulderDashStatus.fromAsciiChar((char)eChar))).withPosition(x, y)).withDraggable(false));
            }
        }
        this.players().forEachRemaining(player -> player.initializeUnchecked(this));
    }

    @Override
    public void run() {
        while (true) {
            this.forEach(player -> player.execute(this));
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private char atPosition(String[] theMap, int y, int x) {
        return theMap[y].charAt(x);
    }
}

