/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.boulderdash;

import org.refcodes.boulderdash.AbstractBoulderDashPlayer;
import org.refcodes.boulderdash.BoulderDashBoard;
import org.refcodes.checkerboard.Rotation;
import org.refcodes.checkerboard.VonNeumannNeighbourhood;
import org.refcodes.component.ConfigureException;
import org.refcodes.graphical.Position;

public abstract class AbstractBoulderDashCrawler
extends AbstractBoulderDashPlayer {
    private VonNeumannNeighbourhood _direction = VonNeumannNeighbourhood.LEFT;
    private Rotation _rotation = Rotation.CLOCKWISE;

    public AbstractBoulderDashCrawler(int aPosX, int aPosY) {
        super(aPosX, aPosY);
    }

    public AbstractBoulderDashCrawler(Position aPosition) {
        super(aPosition);
    }

    public void execute(BoulderDashBoard aContext) {
        VonNeumannNeighbourhood theDirection = this._direction;
        do {
            VonNeumannNeighbourhood tmpDirection;
            Position ePos;
            if (!aContext.hasAtPosition(ePos = this.toAddTo((Position)(tmpDirection = (VonNeumannNeighbourhood)this._direction.next(this._rotation.inverse()))))) {
                this.setPosition(ePos);
                this._direction = tmpDirection;
                return;
            }
            ePos = this.toAddTo((Position)this._direction);
            if (!aContext.hasAtPosition(ePos)) {
                this.setPosition(ePos);
                return;
            }
            this._direction = (VonNeumannNeighbourhood)this._direction.next(this._rotation);
        } while (this._direction != theDirection);
    }

    public void initialize(BoulderDashBoard aContext) throws ConfigureException {
        if (this.getPositionX() < aContext.getGridWidth() - 1 && aContext.hasAtRightOf((Position)this)) {
            this._direction = VonNeumannNeighbourhood.BOTTOM;
            this._rotation = Rotation.CLOCKWISE;
        } else if (this.getPositionY() < aContext.getGridHeight() - 1 && aContext.hasAtBottomOf((Position)this)) {
            this._direction = VonNeumannNeighbourhood.LEFT;
            this._rotation = Rotation.CLOCKWISE;
        } else if (this.getPositionY() > 0 && aContext.hasAtTopOf((Position)this)) {
            this._direction = VonNeumannNeighbourhood.RIGHT;
            this._rotation = Rotation.ANTI_CLOCKWISE;
        } else if (this.getPositionX() > 0 && aContext.hasAtLeftOf((Position)this)) {
            this._direction = VonNeumannNeighbourhood.TOP;
            this._rotation = Rotation.ANTI_CLOCKWISE;
        }
    }
}

