/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.boulderdash;

import javafx.scene.paint.Color;
import org.refcodes.boulderdash.BoulderDashBoard;
import org.refcodes.boulderdash.BoulderDashBoardImpl;
import org.refcodes.boulderdash.BoulderDashPlayer;
import org.refcodes.boulderdash.BoulderDashPlayerFactoryImpl;
import org.refcodes.checkerboard.BackgroundFactory;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.SpriteFactory;
import org.refcodes.checkerboard.alt.javafx.FxCheckerboardViewer;
import org.refcodes.checkerboard.alt.javafx.FxChessboardFactoryImpl;
import org.refcodes.checkerboard.ext.javafx.boulderdash.FxBoulderDashFactoryImpl;
import org.refcodes.component.InitializeException;
import org.refcodes.data.ext.boulderdash.BoulderDashCaveMap;
import org.refcodes.data.ext.boulderdash.BoulderDashCaveMapFactoryImpl;
import org.refcodes.data.ext.boulderdash.BoulderDashStatus;
import org.refcodes.graphical.MoveMode;
import org.refcodes.graphical.ScaleMode;

public class BulderDashAutomaton
implements Runnable {
    private BoulderDashBoard _checkerboard;
    private FxCheckerboardViewer<BoulderDashPlayer, BoulderDashStatus> _checkerboardViewer;

    public BulderDashAutomaton(Checkerboard<BoulderDashPlayer, BoulderDashStatus> aCheckerboard, FxCheckerboardViewer<BoulderDashPlayer, BoulderDashStatus> aCheckerboardViewer) throws InitializeException {
        this._checkerboard = new BoulderDashBoardImpl(aCheckerboard);
        this._checkerboardViewer = aCheckerboardViewer;
        ((FxCheckerboardViewer)this._checkerboardViewer.withSpriteFactory((SpriteFactory)new FxBoulderDashFactoryImpl().withScaleFactor(1.0))).withFieldGap(0);
        this._checkerboardViewer.withBackgroundFactory((BackgroundFactory)new FxChessboardFactoryImpl().withOddFieldColor(Color.rgb((int)0, (int)0, (int)0)).withEvenFieldColor(Color.rgb((int)0, (int)0, (int)0)));
        ((FxCheckerboardViewer)this._checkerboardViewer.withMoveMode(MoveMode.JUMPY)).withScaleMode(ScaleMode.SCALE_GRID);
        this._checkerboardViewer.withMovePlayerDurationInMillis(15);
        BoulderDashPlayerFactoryImpl theFactory = new BoulderDashPlayerFactoryImpl();
        String[] theMap = new BoulderDashCaveMapFactoryImpl().createInstance(BoulderDashCaveMap.CAVE_99_TESTRUN);
        for (int y = 0; y < theMap.length; ++y) {
            for (int x = 0; x < theMap[0].length(); ++x) {
                char eChar = this.atPosition(theMap, y, x);
                if (eChar == ' ') continue;
                this._checkerboard.putPlayer((BoulderDashPlayer)((BoulderDashPlayer)((BoulderDashPlayer)theFactory.createInstance(BoulderDashStatus.fromAsciiChar((char)eChar))).withPosition(x, y)).withDraggable(false));
            }
        }
        this._checkerboard.players().forEachRemaining(player -> player.initializeUnchecked(this._checkerboard));
        ((FxCheckerboardViewer)this._checkerboardViewer.withInitialize()).show();
        this.run();
    }

    @Override
    public void run() {
        while (true) {
            this._checkerboard.forEach(player -> player.execute(this._checkerboard));
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private char atPosition(String[] theMap, int y, int x) {
        return theMap[y].charAt(x);
    }
}

