// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.boulderdash;

import org.refcodes.checkerboard.Rotation;
import org.refcodes.checkerboard.VonNeumannNeighbourhood;
import org.refcodes.component.ConfigureException;
import org.refcodes.graphical.Position;

public abstract class AbstractBoulderDashCrawler extends AbstractBoulderDashPlayer {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private VonNeumannNeighbourhood _direction = VonNeumannNeighbourhood.LEFT;
	private Rotation _rotation = Rotation.CLOCKWISE;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public AbstractBoulderDashCrawler( int aPosX, int aPosY ) {
		super( aPosX, aPosY );
	}

	public AbstractBoulderDashCrawler( Position aPosition ) {
		super( aPosition );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void execute( BoulderDashBoard aContext ) {
		VonNeumannNeighbourhood theDirection = _direction;
		VonNeumannNeighbourhood tmpDirection;
		Position ePos;
		do {
			tmpDirection = _direction.next( _rotation.inverse() );
			ePos = toAddTo( tmpDirection );
			if ( !aContext.hasAtPosition( ePos ) ) {
				setPosition( ePos );
				_direction = tmpDirection;
				// _rotation = _rotation.inverse();
				return;
			}

			ePos = toAddTo( _direction );
			if ( !aContext.hasAtPosition( ePos ) ) {
				setPosition( ePos );
				return;
			}
			_direction = _direction.next( _rotation );
		} while ( _direction != theDirection );
	}

	// /////////////////////////////////////////////////////////////////////////
	// LIFECYCLE:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void initialize( BoulderDashBoard aContext ) throws ConfigureException {
		if ( getPositionX() < aContext.getGridWidth() - 1 && aContext.hasAtRightOf( this ) ) {
			_direction = VonNeumannNeighbourhood.BOTTOM;
			_rotation = Rotation.CLOCKWISE;
		}
		else if ( getPositionY() < aContext.getGridHeight() - 1 && aContext.hasAtBottomOf( this ) ) {
			_direction = VonNeumannNeighbourhood.LEFT;
			_rotation = Rotation.CLOCKWISE;
		}
		else if ( getPositionY() > 0 && aContext.hasAtTopOf( this ) ) {
			_direction = VonNeumannNeighbourhood.RIGHT;
			_rotation = Rotation.ANTI_CLOCKWISE;
		}
		else if ( getPositionX() > 0 && aContext.hasAtLeftOf( this ) ) {
			_direction = VonNeumannNeighbourhood.TOP;
			_rotation = Rotation.ANTI_CLOCKWISE;
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
