// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.boulderdash;

import org.refcodes.component.ConfigureException;
import org.refcodes.data.ext.boulderdash.BoulderDashStatus;
import org.refcodes.graphical.Position;

public abstract class AbstractBoulderDashMineral extends AbstractBoulderDashPlayer {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public AbstractBoulderDashMineral() {
		super();
	}

	public AbstractBoulderDashMineral( int aPosX, int aPosY ) {
		super( aPosX, aPosY );
	}

	public AbstractBoulderDashMineral( Position aPosition ) {
		super( aPosition );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void execute( BoulderDashBoard aContext ) throws RuntimeException {
		if ( aContext.isInHeight( getPositionY() + 1 ) ) {
			if ( !aContext.hasAtBottomOf( this ) ) {
				setPositionY( getPositionY() + 1 );
			}
			else {
				// TDOO: Does this reflect the actual behavior? |-->
				BoulderDashPlayer theBottomPlayer = aContext.atBottomOf( this );
				if ( theBottomPlayer.getStatus() != BoulderDashStatus.DIRT ) {
					// TDOO: Does this reflect the actual behavior? <--|
					if ( aContext.isInWidth( getPositionX() + 1 ) && !aContext.hasAtRightOf( this ) && !aContext.hasAtBottomRightOf( this ) ) {
						setPositionX( getPositionX() + 1 );
					}
					else if ( aContext.isInWidth( getPositionX() - 1 ) && !aContext.hasAtLeftOf( this ) && !aContext.hasAtBottomLeftOf( this ) ) {
						setPositionX( getPositionX() - 1 );
					}
				}
			}
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// LIFECYCLE:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void initialize( BoulderDashBoard aContext ) throws ConfigureException {}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
