// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.boulderdash;

import org.refcodes.component.InitializeException;
import org.refcodes.data.ext.boulderdash.BoulderDashCaveMap;
import org.refcodes.data.ext.boulderdash.BoulderDashCaveMapFactory;
import org.refcodes.data.ext.boulderdash.BoulderDashStatus;

public class BoulderDashAutomaton extends BoulderDashBoard implements Runnable {

	/**
	 * Constructs the {@link BoulderDashAutomaton}.
	 * 
	 * @param aCaveMap The {@link BoulderDashCaveMap} being the map layout to
	 *        use.
	 * 
	 * @throws InitializeException thrown in case initializing a component
	 *         caused problems. Usually a method similar to "initialize()"
	 *         throws such an exception.
	 */
	public BoulderDashAutomaton( BoulderDashCaveMap aCaveMap ) throws InitializeException {
		this( new BoulderDashCaveMapFactory().createInstance( aCaveMap ) );
	}

	/**
	 * Constructs the {@link BoulderDashAutomaton}.
	 * 
	 * @param aCaveMap The BoulderDash cave map being the map layout to use.
	 * 
	 * @throws InitializeException thrown in case initializing a component
	 *         caused problems. Usually a method similar to "initialize()"
	 *         throws such an exception.
	 */
	public BoulderDashAutomaton( String[] aCaveMap ) throws InitializeException {
		setGridDimension( aCaveMap[0].length(), aCaveMap.length );
		BoulderDashPlayerFactory theFactory = new BoulderDashPlayerFactory();
		char eChar;
		for ( int y = 0; y < aCaveMap.length; y++ ) {
			for ( int x = 0; x < aCaveMap[0].length(); x++ ) {
				eChar = atPosition( aCaveMap, y, x );
				if ( eChar != ' ' ) {
					putPlayer( theFactory.createInstance( BoulderDashStatus.fromAsciiChar( eChar ) ).withPosition( x, y ).withDraggable( false ) );
				}
			}
		}
		players().forEachRemaining( player -> player.initializeUnchecked( this ) );
	}

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void run() {
		while ( true ) {
			forEach( player -> player.execute( this ) );
			try {
				Thread.sleep( 150 );
			}
			catch ( InterruptedException ignore ) {}
		}

	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	private char atPosition( String[] theMap, int y, int x ) {
		return theMap[y].charAt( x );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
