// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.boulderdash;

import org.refcodes.data.ext.boulderdash.BoulderDashStatus;
import org.refcodes.exception.BugException;
import org.refcodes.factory.LookupFactory;

public class BoulderDashPlayerFactory implements LookupFactory<BoulderDashPlayer, BoulderDashStatus> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public BoulderDashPlayer createInstance( BoulderDashStatus aIdentifier ) {
		switch ( aIdentifier ) {
		case AMOEBA:
			return new Amoeba();
		case BOULDER:
			return new Boulder();
		case BRICK_WALL:
			return new BrickWall();
		case BUTTERFLY:
			return new Butterfly();
		case DIAMOND:
			return new Diamond();
		case DIAMOND_BIRTH:
			return new Diamond( BoulderDashStatus.DIAMOND_BIRTH );
		case DIRT:
			return new Dirt();
		case EXPANDING_WALL:
			return new ExpandingWall();
		case FIREFLY:
			return new Firefly();
		case MAGIC_WALL:
			return new MagicWall();
		case MAGIC_WALL_EXPIRED:
			return new MagicWall( BoulderDashStatus.MAGIC_WALL_EXPIRED );
		case NONE:
			return null;
		case ROCKFORD:
			return new Rockford();
		case ROCKFORD_BIRTH:
			return new Rockford( BoulderDashStatus.ROCKFORD_BIRTH );
		case ROCKFORD_BLINKING:
			return new Rockford( BoulderDashStatus.ROCKFORD_BLINKING );
		case ROCKFORD_BLINKING_TRAPPING_FOOT:
			return new Rockford( BoulderDashStatus.ROCKFORD_TRAPPING_FOOT );
		case ROCKFORD_LEFT:
			return new Rockford( BoulderDashStatus.ROCKFORD_LEFT );
		case ROCKFORD_RIGHT:
			return new Rockford( BoulderDashStatus.ROCKFORD_RIGHT );
		case ROCKFORD_TRAPPING_FOOT:
			return new Rockford( BoulderDashStatus.ROCKFORD_TRAPPING_FOOT );
		case STEEL_WALL:
			return new SteelWall();
		case STEEL_WALL_BLINKING:
			return new SteelWall( BoulderDashStatus.STEEL_WALL_BLINKING );
		case STEEL_WALL_OPEN:
			return new SteelWall( BoulderDashStatus.STEEL_WALL_OPEN );
		}
		throw new BugException( "Missing case statement for <" + aIdentifier + "> in implementation!" );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
