package org.refcodes.checkerboard;

import java.util.Map;

import org.refcodes.component.Component;
import org.refcodes.graphical.GridDimension.GridDimensionBuilder;
import org.refcodes.graphical.GridDimension.GridDimensionProperty;
import org.refcodes.graphical.GridModeAccessor.GridModeBuilder;
import org.refcodes.graphical.GridModeAccessor.GridModeProperty;
import org.refcodes.graphical.Position;
import org.refcodes.observer.Observable;

public interface Checkerboard<S> extends Players<S>, Observable<CheckerboardObserver<S>>, GridDimensionProperty, GridDimensionBuilder<Checkerboard<S>>, GridModeProperty, GridModeBuilder<Checkerboard<S>>, Component {

	boolean hasAtPosition( Position aPos ) throws IndexOutOfBoundsException;

	boolean hasAtPosition( int aPosX, int aPosY ) throws IndexOutOfBoundsException;

	Player<S> atPosition( Position aPos ) throws IndexOutOfBoundsException;

	Player<S> atPosition( int aPosX, int aPosY ) throws IndexOutOfBoundsException;

	Map<Integer, Player<S>> getRow( int aRow ) throws IndexOutOfBoundsException;

	Map<Integer, Player<S>> getColumn( int aColumn ) throws IndexOutOfBoundsException;

	boolean hasAtTopOf( Position aPos ) throws IndexOutOfBoundsException;

	Player<S> atTopOf( Position aPos ) throws IndexOutOfBoundsException;

	boolean hasAtTopRightOf( Position aPos ) throws IndexOutOfBoundsException;

	Player<S> atTopRightOf( Position aPos ) throws IndexOutOfBoundsException;

	boolean hasAtRightOf( Position aPos ) throws IndexOutOfBoundsException;

	Player<S> atRightOf( Position aPos ) throws IndexOutOfBoundsException;

	boolean hasAtBottomRightOf( Position aPos ) throws IndexOutOfBoundsException;

	Player<S> atBottomRightOf( Position aPos ) throws IndexOutOfBoundsException;

	boolean hasAtBottomOf( Position aPos ) throws IndexOutOfBoundsException;

	Player<S> atBottomOf( Position aPos ) throws IndexOutOfBoundsException;

	boolean hasAtBottomLeftOf( Position aPos ) throws IndexOutOfBoundsException;

	Player<S> atBottomLeftOf( Position aPos ) throws IndexOutOfBoundsException;

	boolean hasAtLeftOf( Position aPos ) throws IndexOutOfBoundsException;

	Player<S> atLeftOf( Position aPos ) throws IndexOutOfBoundsException;

	boolean hasAtTopLeftOf( Position aPos ) throws IndexOutOfBoundsException;

	Player<S> atTopLeftOf( Position aPos ) throws IndexOutOfBoundsException;
}
