// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.checkerboard;

/**
 * Provides an accessor for a player property.
 */
public interface CheckerboardAccessor<S> {

	/**
	 * Retrieves the player from the player property.
	 * 
	 * @return The player stored by the player property.
	 */
	Checkerboard<S> getCheckerboard();

	/**
	 * Provides a mutator for a player property.
	 */
	public interface CheckerboardMutator<S> {

		/**
		 * Sets the player for the player property.
		 * 
		 * @param aCheckerboard The player to be stored by the player property.
		 */
		void setCheckerboard( Checkerboard<S> aCheckerboard );
	}

	/**
	 * Provides a builder method for a player property returning the builder for
	 * applying multiple build operations.
	 * 
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface CheckerboardBuilder<S, B extends CheckerboardBuilder<S, B>> {

		/**
		 * Sets the player for the player property.
		 * 
		 * @param aCheckerboard The player to be stored by the player property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withCheckerboard( Checkerboard<S> aCheckerboard );
	}

	/**
	 * Provides a player property.
	 */
	public interface CheckerboardProperty<S> extends CheckerboardAccessor<S>, CheckerboardMutator<S> {}
}
