package org.refcodes.checkerboard;

import org.refcodes.exception.VetoException;
import org.refcodes.observer.ObservableObserver;

public interface CheckerboardObserver<S> extends ObservableObserver<Checkerboard<S>> {

	void onCheckerboardEvent( CheckerboardEvent<S> aCheckerboardEvent );

	void onPlayerAddedEvent( PlayerAddedEvent<S> aCheckerboardEvent );

	void onPlayerRemovedEvent( PlayerRemovedEvent<S> aCheckerboardEvent );

	void onGridModeChangedEvent( GridModeChangedEvent<S> aCheckerboardEvent );

	void onGridDimensionChangedEvent( GridDimensionChangedEvent<S> aCheckerboardEvent );

	void onViewportOffsetChangedEvent( ViewportOffsetChangedEvent<S> aCheckerboardEvent );

	void onViewportDimensionChangedEvent( ViewportDimensionChangedEvent<S> aCheckerboardEvent );

	void onPlayerEvent( PlayerEvent<S> aPlayerEvent, Checkerboard<S> aSource );

	void onChangePositionEvent( ChangePositionEvent<S> aPlayerEvent, Checkerboard<S> aSource ) throws VetoException;

	void onPositionChangedEvent( PositionChangedEvent<S> aPlayerEvent, Checkerboard<S> aSource );

	void onStateChangedEvent( StateChangedEvent<S> aPlayerEvent, Checkerboard<S> aSource );

	void onVisibilityChangedEvent( VisibilityChangedEvent<S> aPlayerEvent, Checkerboard<S> aSource );

	void onDraggabilityChangedEvent( DraggabilityChangedEvent<S> aPlayerEvent, Checkerboard<S> aSource );
}
