package org.refcodes.checkerboard;

import org.refcodes.graphical.DraggableAccessor.DraggableBuilder;
import org.refcodes.graphical.DraggableAccessor.DraggableProperty;
import org.refcodes.graphical.Position.PositionBuilder;
import org.refcodes.graphical.Position.PositionProperty;
import org.refcodes.graphical.VisibleAccessor.VisibleBuilder;
import org.refcodes.graphical.VisibleAccessor.VisibleProperty;
import org.refcodes.mixin.StateAccessor.StateBuilder;
import org.refcodes.mixin.StateAccessor.StateMutator;
import org.refcodes.mixin.StateAccessor.StateProperty;
import org.refcodes.observer.Observable;

/**
 * A {@link Player} defines an actor (player) on a playground (checkerboard). It
 * is observable in order to signal observers (checkerboard) on state updates.
 *
 * @param <S> The state if the player (dead, alive, strong, weak, king, queen,
 *        Pac-Man, ghost, fire, wood, water, strong queen, weak king, etc).
 */
public interface Player<S> extends PositionProperty, PositionBuilder<Player<S>>, Observable<PlayerObserver<S>>, StateMutator<S>, StateProperty<S>, StateBuilder<S, Player<S>>, VisibleProperty, VisibleBuilder<Player<S>>, DraggableProperty, DraggableBuilder<Player<S>> {

	/**
	 * Causes the {@link Player} to blink.
	 */
	default void blink() {
		for ( int i = 0; i < 6; i++ ) {
			setVisible( !isVisible() );
			try {
				Thread.sleep( 150 );
			}
			catch ( InterruptedException ignore ) {}
		}
	}

}
