// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.checkerboard;

import java.util.Collection;
import java.util.Set;

import org.refcodes.collection.Relation;

/**
 * @author steiner
 *
 */
public interface Sprites<SPS extends Sprites<SPS, S, IMG>, S, IMG> {

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	SPS withSprite( Relation<S, IMG> aRelation );

	SPS withSprite( S aStatus, IMG aSprite );

	IMG removeSprite( S aStatus );

	void clearSprites();

	boolean hasSprites();

	int spriteCount();

	Collection<IMG> values();

	Set<S> states();

	IMG getSprite( S aStatus );

	boolean containsSprite( S aStatus );

	IMG putSprite( Relation<S, IMG> aRelation );

	IMG putSprite( S aStatus, IMG aSprite );

}
