package org.refcodes.checkerboard.impls;

import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.CheckerboardAction;
import org.refcodes.checkerboard.CheckerboardEvent;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.PlayerAccessor;

public abstract class AbstractCheckerboardEvent<S> implements CheckerboardEvent<S> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private Checkerboard<S> _source;
	private CheckerboardAction _action;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public AbstractCheckerboardEvent( CheckerboardAction aAction, Checkerboard<S> aSource ) {
		_source = aSource;
		_action = aAction;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public CheckerboardAction getAction() {
		return _action;
	}

	@Override
	public Checkerboard<S> getSource() {
		return _source;
	}

	@Override
	public String toString() {
		return "action := " + _action;

	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	public static abstract class AbstractPlayerCheckerboardEvent<S> extends AbstractCheckerboardEvent<S>implements PlayerAccessor<S> {

		// /////////////////////////////////////////////////////////////////////
		// STATICS:
		// /////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////
		// CONSTANTS:
		// /////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////
		// VARIABLES:
		// /////////////////////////////////////////////////////////////////////

		private Player<S> _player;

		// /////////////////////////////////////////////////////////////////////
		// CONSTRUCTORS:
		// /////////////////////////////////////////////////////////////////////

		public AbstractPlayerCheckerboardEvent( CheckerboardAction aAction, Player<S> aPlayer, Checkerboard<S> aSource ) {
			super( aAction, aSource );
			_player = aPlayer;
		}

		// /////////////////////////////////////////////////////////////////////
		// INJECTION:
		// /////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////
		// METHODS:
		// /////////////////////////////////////////////////////////////////////
		@Override
		public Player<S> getPlayer() {
			return _player;
		}

		// /////////////////////////////////////////////////////////////////////
		// HOOKS:
		// /////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////
		// HELPER:
		// /////////////////////////////////////////////////////////////////////

		// /////////////////////////////////////////////////////////////////////
		// INNER CLASSES:
		// /////////////////////////////////////////////////////////////////////

	}

}
