package org.refcodes.checkerboard.impls;

import org.refcodes.checkerboard.CheckerboardViewer;
import org.refcodes.checkerboard.CheckerboardViewerAction;
import org.refcodes.checkerboard.CheckerboardViewerEvent;

public abstract class AbstractCheckerboardViewerEvent<S> implements CheckerboardViewerEvent<S> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private CheckerboardViewer<S, ?> _source;
	private CheckerboardViewerAction _action;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public AbstractCheckerboardViewerEvent( CheckerboardViewerAction aAction, CheckerboardViewer<S, ?> aSource ) {
		_source = aSource;
		_action = aAction;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public CheckerboardViewerAction getAction() {
		return _action;
	}

	@Override
	public CheckerboardViewer<S, ?> getSource() {
		return _source;
	}

	@Override
	public String toString() {
		return "action := " + _action;

	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////
}
