package org.refcodes.checkerboard.impls;

import org.refcodes.checkerboard.BackgroundFactory;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.GraphicalCheckerboardViewer;
import org.refcodes.checkerboard.SpriteFactory;
import org.refcodes.component.InitializeException;
import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.FieldDimension;
import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.MoveMode;
import org.refcodes.graphical.ScaleMode;
import org.refcodes.observer.UnsubscribeEvent;

public abstract class AbstractGraphicalCheckerboardViewer<S, IMG, SF extends SpriteFactory<IMG, S, ? extends CBV>,

BF extends BackgroundFactory<IMG, ? extends CBV>,

CBV extends GraphicalCheckerboardViewer<S, IMG, SF, BF, CBV>> extends AbstractCheckerboardViewer<S, IMG, SF, CBV>implements GraphicalCheckerboardViewer<S, IMG, SF, BF, CBV> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private int _fieldHeight = -1;
	private int _fieldWidth = -1;
	private int _fieldGap = 0;
	private MoveMode _moveMode = MoveMode.SMOOTH;
	private ScaleMode _scaleMode = ScaleMode.SCALE_GRID;
	private SF _spriteFactory = null;
	private BF _backgroundFactory = null;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public int getFieldGap() {
		return _fieldGap;
	}

	@Override
	public void setFieldGap( int aFieldGap ) {
		_fieldGap = aFieldGap;
	}

	@SuppressWarnings("unchecked")
	@Override
	public CBV withFieldGap( int aFieldGap ) {
		setFieldGap( aFieldGap );
		return (CBV) this;
	}

	@Override
	public void show() {
		setVisible( true );
	}

	@Override
	public void hide() {
		setVisible( false );
	}

	@Override
	public MoveMode getMoveMode() {
		return _moveMode;
	}

	@Override
	public void setMoveMode( MoveMode aMode ) {
		_moveMode = aMode;
	}

	@Override
	public ScaleMode getScaleMode() {
		return _scaleMode;
	}

	@Override
	public void setScaleMode( ScaleMode aMode ) {
		_scaleMode = aMode;
	}

	@Override
	public int getFieldHeight() {
		return _fieldHeight;
	}

	@Override
	public void setFieldDimension( int aFieldWidth, int aFieldHeight ) {
		_fieldWidth = aFieldWidth;
		_fieldHeight = aFieldHeight;
	}

	@Override
	public void setFieldDimension( FieldDimension aField ) {
		setFieldDimension( aField.getFieldWidth(), aField.getFieldHeight() );

	}

	@Override
	public void setFieldDimension( Dimension aDimension ) {
		setFieldDimension( aDimension.getWidth(), aDimension.getHeight() );

	}

	@Override
	public void setFieldWidth( int aWidth ) {
		setFieldDimension( aWidth, _fieldHeight );
	}

	@Override
	public int getFieldWidth() {
		return _fieldWidth;
	}

	@Override
	public void setFieldHeight( int aHeight ) {
		setFieldDimension( _fieldWidth, aHeight );
	}

	@Override
	public int getContainerHeight() {
		return getFieldHeight() * getViewportHeight() + (getFieldGap() * (getViewportHeight() - 1)) + ((getCheckerboard().getGridMode() == GridMode.CLOSED) ? (getFieldGap() * 2) : 0);
	}

	@Override
	public int getContainerWidth() {
		return getFieldWidth() * getViewportWidth() + (getFieldGap() * (getViewportWidth() - 1)) + ((getCheckerboard().getGridMode() == GridMode.CLOSED) ? (getFieldGap() * 2) : 0);
	}

	@SuppressWarnings("unchecked")
	@Override
	public CBV withFieldWidth( int aWidth ) {
		setFieldWidth( aWidth );
		return (CBV) this;
	}

	@SuppressWarnings("unchecked")
	@Override
	public CBV withFieldHeight( int aHeight ) {
		setFieldHeight( aHeight );
		return (CBV) this;
	}

	@SuppressWarnings("unchecked")
	@Override
	public CBV withFieldDimension( FieldDimension aField ) {
		setFieldDimension( aField );
		return (CBV) this;
	}

	@SuppressWarnings("unchecked")
	@Override
	public CBV withFieldDimension( Dimension aDimension ) {
		setFieldDimension( aDimension );
		return (CBV) this;
	}

	@SuppressWarnings("unchecked")
	@Override
	public CBV withInitialize() throws InitializeException {
		initialize();
		return (CBV) this;
	}

	@SuppressWarnings("unchecked")
	@Override
	public CBV withShow() {
		setVisible( true );
		return (CBV) this;
	}

	@SuppressWarnings("unchecked")
	@Override
	public CBV withHide() {
		setVisible( false );
		return (CBV) this;
	}

	@SuppressWarnings("unchecked")
	@Override
	public CBV withVisible( boolean isVisible ) {
		setVisible( isVisible );
		return (CBV) this;
	}

	@SuppressWarnings("unchecked")
	@Override
	public CBV withMoveMode( MoveMode aMode ) {
		setMoveMode( aMode );
		return (CBV) this;
	}

	@SuppressWarnings("unchecked")
	@Override
	public CBV withScaleMode( ScaleMode aMode ) {
		setScaleMode( aMode );
		return (CBV) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int toTotalWidth() {
		int theTotalWidth = getFieldWidth() * getViewportWidth() + (getFieldGap() * (getViewportWidth() - 1));
		if ( getGridMode() == GridMode.CLOSED ) {
			theTotalWidth += (getFieldGap() * 2);
		}
		return theTotalWidth;
	}

	@Override
	public void setFieldDimension( int aFieldWidth, int aFieldHeight, int aGap ) {
		setFieldDimension( aFieldWidth, aFieldHeight );
		setFieldGap( aGap );
	}

	@SuppressWarnings("unchecked")
	@Override
	public CBV withFieldDimension( int aFieldWidth, int aFieldHeight, int aGap ) {
		setFieldDimension( aFieldWidth, aFieldHeight, aGap );
		return (CBV) this;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int toTotalHeight() {
		int theTotalHeight = getFieldHeight() * getViewportHeight() + (getFieldGap() * (getViewportHeight() - 1));
		if ( getGridMode() == GridMode.CLOSED ) {
			theTotalHeight += (getFieldGap() * 2);
		}
		return theTotalHeight;
	}

	@SuppressWarnings("unchecked")
	@Override
	public CBV withFieldDimension( int aFieldWidth, int aFieldHeight ) {
		setFieldDimension( aFieldWidth, aFieldHeight );
		return (CBV) this;
	}

	@Override
	public void setSpriteFactory( SF aSpriteFactory ) {
		_spriteFactory = aSpriteFactory;
	}

	@Override
	public SF getSpriteFactory() {
		return _spriteFactory;
	}

	@SuppressWarnings("unchecked")
	@Override
	public CBV withSpriteFactory( SF aSpriteFactory ) {
		setSpriteFactory( aSpriteFactory );
		return (CBV) this;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public GraphicalCheckerboardViewer<S, IMG, SF, BF, CBV> withBackgroundFactory( BF aBackgroundFactory ) {
		setBackgroundFactory( aBackgroundFactory );
		return (CBV) this;
	}

	@Override
	public void setBackgroundFactory( BF aBackgroundFactory ) {
		_backgroundFactory = aBackgroundFactory;
	}

	@Override
	public BF getBackgroundFactory() {
		return _backgroundFactory;
	}

	// /////////////////////////////////////////////////////////////////////////
	// LIFECYCLE:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public void onUnsubscribe( UnsubscribeEvent<Checkerboard<S>> aUnsubscribeEvent ) {}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	protected Checkerboard<S> getCheckerboard() {
		return super.getCheckerboard();
	}
	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
