package org.refcodes.checkerboard.impls;

import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.PlayerAction;
import org.refcodes.checkerboard.PlayerEvent;

public abstract class AbstractPlayerEvent<S> implements PlayerEvent<S> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private Player<S> _source;
	private PlayerAction _action;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public AbstractPlayerEvent( PlayerAction aAction, Player<S> aSource ) {
		_action = aAction;
		_source = aSource;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public PlayerAction getAction() {
		return _action;
	}

	@Override
	public Player<S> getSource() {
		return _source;
	}

	@Override
	public String toString() {
		return "action := " + _action;

	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}