package org.refcodes.checkerboard.impls;

import org.refcodes.checkerboard.ChangePositionEvent;
import org.refcodes.checkerboard.Player;
import org.refcodes.graphical.Position;
import org.refcodes.graphical.impls.PositionImpl;

public class ChangePositionEventImpl<S> extends AbstractPlayerEvent<S> implements ChangePositionEvent<S> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private int _posX;
	private int _posY;
	private Position _precedingPosition;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public ChangePositionEventImpl( int aPosX, int aPosY, int aPrePosX, int aPrePosY, Player<S> aSource ) {
		super( ACTION, aSource );
		_posX = aPosX;
		_posY = aPosY;
		_precedingPosition = new PositionImpl( aPrePosX, aPrePosY );
	}

	public ChangePositionEventImpl( Position aPosition, Position aPrecedingPosition, Player<S> aSource ) {
		super( ACTION, aSource );
		_posX = aPosition.getPositionX();
		_posY = aPosition.getPositionY();
		_precedingPosition = aPrecedingPosition;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public Position getPrecedingPosition() {
		return _precedingPosition;
	}

	@Override
	public int getPositionX() {
		return _posX;
	}

	@Override
	public int getPositionY() {
		return _posY;
	}
	
	
	@Override
	public int getVectorX() {
		return _posX - _precedingPosition.getPositionX();
	}

	@Override
	public int getVectorY() {
		return _posY - _precedingPosition.getPositionY();
	}

	@Override
	public String toString() {
		return super.toString() + ", x := " + _posX + ", y := " + _posY + " (state before: " + _precedingPosition + ")";
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
