package org.refcodes.checkerboard.impls;

import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.GridDimensionChangedEvent;
import org.refcodes.graphical.GridDimension;
import org.refcodes.graphical.impls.GridDimensionImpl;

public class GridDimensionChangedEventImpl<S> extends AbstractCheckerboardEvent<S>implements GridDimensionChangedEvent<S> {

	private int _height;
	private int _width;
	private GridDimension _precedingDimension;

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public GridDimensionChangedEventImpl( int aWidth, int aHeight, int aPrecedingWidth, int aPrecedingHeigt, Checkerboard<S> aSource ) {
		super( ACTION, aSource );
		_width = aWidth;
		_height = aHeight;
		_precedingDimension = new GridDimensionImpl( aPrecedingWidth, aPrecedingHeigt );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public int getGridHeight() {
		return _height;
	}

	@Override
	public int getGridWidth() {
		return _width;
	}

	@Override
	public GridDimension getPrecedingGridDimension() {
		return _precedingDimension;
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + "(" + _width + " x " + _height + ")@" + hashCode();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
