package org.refcodes.checkerboard.impls;

import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.StateChangedEvent;

public class StateChangedEventImpl<S> extends AbstractPlayerEvent<S> implements StateChangedEvent<S> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private S _state;
	private S _precedingState;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public StateChangedEventImpl( S aState, S aPrecedingState, Player<S> aSource ) {
		super( ACTION, aSource );
		_state = aState;
		_precedingState = aPrecedingState;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public S getState() {
		return _state;
	}

	@Override
	public S getPrecedingState() {
		return _precedingState;
	}

	@Override
	public String toString() {
		return super.toString() + ", state := " + _state + " (state before: " + _precedingState + ")";
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
