package org.refcodes.checkerboard.impls;

import org.refcodes.checkerboard.CheckerboardViewer;
import org.refcodes.checkerboard.ViewportDimensionChangedEvent;
import org.refcodes.graphical.ViewportDimension;
import org.refcodes.graphical.ViewportOffset;
import org.refcodes.graphical.impls.ViewportDimensionImpl;
import org.refcodes.graphical.impls.ViewportOffsetImpl;

public class ViewportDimensionChangedEventImpl<S> extends AbstractCheckerboardViewerEvent<S>implements ViewportDimensionChangedEvent<S> {

	private int _height;
	private int _width;
	private ViewportDimension _precedingDimension;
	private ViewportOffset _viewportOffset;

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public ViewportDimensionChangedEventImpl( int aWidth, int aHeight, int aPrecedingWidth, int aPrecedingHeigt, int aOffsetX, int aOffsetY, CheckerboardViewer<S, ?> aSource ) {
		super( ACTION, aSource );
		_width = aWidth;
		_height = aHeight;
		_precedingDimension = new ViewportDimensionImpl( aPrecedingWidth, aPrecedingHeigt );
		_viewportOffset = new ViewportOffsetImpl( aOffsetX, aOffsetY );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public int getViewportHeight() {
		return _height;
	}

	@Override
	public int getViewportWidth() {
		return _width;
	}

	@Override
	public ViewportDimension getPrecedingViewportDimension() {
		return _precedingDimension;
	}

	@Override
	public ViewportOffset getViewportOffset() {
		return _viewportOffset;
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + "(" + _width + " x " + _height + ")@" + hashCode();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
