package org.refcodes.checkerboard.impls;

import org.refcodes.checkerboard.CheckerboardViewer;
import org.refcodes.checkerboard.ViewportOffsetChangedEvent;
import org.refcodes.graphical.ViewportOffset;
import org.refcodes.graphical.impls.ViewportOffsetImpl;

public class ViewportOffsetChangedEventImpl<S> extends AbstractCheckerboardViewerEvent<S>implements ViewportOffsetChangedEvent<S> {

	private int _offsetX;
	private int _offsetY;
	private ViewportOffset _precedingOffset;

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public ViewportOffsetChangedEventImpl( int aOffsetY, int aOffsetX, int aPrecedingOffsetX, int aPrecedingOffsetY, CheckerboardViewer<S, ?> aSource ) {
		super( ACTION, aSource );
		_offsetX = aOffsetX;
		_offsetY = aOffsetY;
		_precedingOffset = new ViewportOffsetImpl( aPrecedingOffsetX, aPrecedingOffsetY );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Override
	public int getViewportOffsetX() {
		return _offsetX;
	}

	@Override
	public int getViewportOffsetY() {
		return _offsetY;
	}

	@Override
	public ViewportOffset getPrecedingViewportOffset() {
		return _precedingOffset;
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + "(" + _offsetX + " x " + _offsetY + ")@" + hashCode();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
