/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard.impls;

import org.junit.Assert;
import org.junit.Test;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.impls.CheckerboardImpl;
import org.refcodes.checkerboard.impls.PlayerImpl;
import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.Position;

public class CheckerboardTest {
    @Test
    public void testEvenCheckerboardPositions() {
        Checkerboard theCheckerboard = new CheckerboardImpl().withGridDimension(3, 3);
        PlayerImpl thePlayer = new PlayerImpl(1, 1);
        PlayerImpl theTopPlayer = new PlayerImpl(1, 0);
        PlayerImpl theLeftPlayer = new PlayerImpl(0, 1);
        PlayerImpl theBottomPlayer = new PlayerImpl(1, 2);
        PlayerImpl theRightPlayer = new PlayerImpl(2, 1);
        theCheckerboard.putPlayer((Player)theTopPlayer);
        theCheckerboard.putPlayer((Player)theLeftPlayer);
        theCheckerboard.putPlayer((Player)theBottomPlayer);
        theCheckerboard.putPlayer((Player)theRightPlayer);
        Assert.assertTrue((boolean)theCheckerboard.hasAtTopOf((Position)thePlayer));
        Assert.assertTrue((boolean)theCheckerboard.hasAtLeftOf((Position)thePlayer));
        Assert.assertTrue((boolean)theCheckerboard.hasAtBottomOf((Position)thePlayer));
        Assert.assertTrue((boolean)theCheckerboard.hasAtRightOf((Position)thePlayer));
        Assert.assertFalse((boolean)theCheckerboard.hasAtTopLeftOf((Position)thePlayer));
        Assert.assertFalse((boolean)theCheckerboard.hasAtBottomLeftOf((Position)thePlayer));
        Assert.assertFalse((boolean)theCheckerboard.hasAtBottomRightOf((Position)thePlayer));
        Assert.assertFalse((boolean)theCheckerboard.hasAtTopRightOf((Position)thePlayer));
        Assert.assertEquals((Object)theTopPlayer, (Object)theCheckerboard.atTopOf((Position)thePlayer));
        Assert.assertEquals((Object)theRightPlayer, (Object)theCheckerboard.atRightOf((Position)thePlayer));
        Assert.assertEquals((Object)theBottomPlayer, (Object)theCheckerboard.atBottomOf((Position)thePlayer));
        Assert.assertEquals((Object)theLeftPlayer, (Object)theCheckerboard.atLeftOf((Position)thePlayer));
        Assert.assertNull((Object)theCheckerboard.atTopRightOf((Position)thePlayer));
        Assert.assertNull((Object)theCheckerboard.atBottomRightOf((Position)thePlayer));
        Assert.assertNull((Object)theCheckerboard.atBottomLeftOf((Position)thePlayer));
        Assert.assertNull((Object)theCheckerboard.atTopLeftOf((Position)thePlayer));
    }

    @Test
    public void testOddCheckerboardPositions() {
        Checkerboard theCheckerboard = new CheckerboardImpl().withGridDimension(3, 3);
        PlayerImpl thePlayer = new PlayerImpl(1, 1);
        PlayerImpl theTopRightPlayer = new PlayerImpl(2, 0);
        PlayerImpl theBottomRightPlayer = new PlayerImpl(2, 2);
        PlayerImpl theBottomLeftPlayer = new PlayerImpl(0, 2);
        PlayerImpl theTopLeftPlayer = new PlayerImpl(0, 0);
        theCheckerboard.putPlayer((Player)theTopRightPlayer);
        theCheckerboard.putPlayer((Player)theBottomRightPlayer);
        theCheckerboard.putPlayer((Player)theBottomLeftPlayer);
        theCheckerboard.putPlayer((Player)theTopLeftPlayer);
        Assert.assertFalse((boolean)theCheckerboard.hasAtTopOf((Position)thePlayer));
        Assert.assertFalse((boolean)theCheckerboard.hasAtLeftOf((Position)thePlayer));
        Assert.assertFalse((boolean)theCheckerboard.hasAtBottomOf((Position)thePlayer));
        Assert.assertFalse((boolean)theCheckerboard.hasAtRightOf((Position)thePlayer));
        Assert.assertTrue((boolean)theCheckerboard.hasAtTopLeftOf((Position)thePlayer));
        Assert.assertTrue((boolean)theCheckerboard.hasAtBottomLeftOf((Position)thePlayer));
        Assert.assertTrue((boolean)theCheckerboard.hasAtBottomRightOf((Position)thePlayer));
        Assert.assertTrue((boolean)theCheckerboard.hasAtTopRightOf((Position)thePlayer));
        Assert.assertEquals((Object)theTopRightPlayer, (Object)theCheckerboard.atTopRightOf((Position)thePlayer));
        Assert.assertEquals((Object)theBottomRightPlayer, (Object)theCheckerboard.atBottomRightOf((Position)thePlayer));
        Assert.assertEquals((Object)theBottomLeftPlayer, (Object)theCheckerboard.atBottomLeftOf((Position)thePlayer));
        Assert.assertEquals((Object)theTopLeftPlayer, (Object)theCheckerboard.atTopLeftOf((Position)thePlayer));
        Assert.assertNull((Object)theCheckerboard.atTopOf((Position)thePlayer));
        Assert.assertNull((Object)theCheckerboard.atBottomOf((Position)thePlayer));
        Assert.assertNull((Object)theCheckerboard.atLeftOf((Position)thePlayer));
        Assert.assertNull((Object)theCheckerboard.atRightOf((Position)thePlayer));
    }

    @Test
    public void testPeriodicCheckerboardPositions() {
        Checkerboard theCheckerboard = (Checkerboard)new CheckerboardImpl().withGridDimension(3, 3).withGridMode(GridMode.PERIODIC);
        PlayerImpl theTopPlayer = new PlayerImpl(1, 0);
        PlayerImpl theLeftPlayer = new PlayerImpl(0, 1);
        PlayerImpl theBottomPlayer = new PlayerImpl(1, 2);
        PlayerImpl theRightPlayer = new PlayerImpl(2, 1);
        theCheckerboard.putPlayer((Player)theTopPlayer);
        theCheckerboard.putPlayer((Player)theLeftPlayer);
        theCheckerboard.putPlayer((Player)theBottomPlayer);
        theCheckerboard.putPlayer((Player)theRightPlayer);
        Assert.assertTrue((boolean)theCheckerboard.hasAtBottomOf((Position)theBottomPlayer));
        Assert.assertTrue((boolean)theCheckerboard.hasAtRightOf((Position)theRightPlayer));
        Assert.assertTrue((boolean)theCheckerboard.hasAtBottomOf((Position)theBottomPlayer));
        Assert.assertTrue((boolean)theCheckerboard.hasAtLeftOf((Position)theLeftPlayer));
    }

    @Test
    public void testClosedCheckerboardPositions() {
        Checkerboard theCheckerboard = (Checkerboard)new CheckerboardImpl().withGridDimension(3, 3).withGridMode(GridMode.CLOSED);
        PlayerImpl theTopPlayer = new PlayerImpl(1, 0);
        PlayerImpl theLeftPlayer = new PlayerImpl(0, 1);
        PlayerImpl theBottomPlayer = new PlayerImpl(1, 2);
        PlayerImpl theRightPlayer = new PlayerImpl(2, 1);
        theCheckerboard.putPlayer((Player)theTopPlayer);
        theCheckerboard.putPlayer((Player)theLeftPlayer);
        theCheckerboard.putPlayer((Player)theBottomPlayer);
        theCheckerboard.putPlayer((Player)theRightPlayer);
        try {
            theCheckerboard.hasAtBottomOf((Position)theBottomPlayer);
            Assert.fail((String)"Expected an index out of bounds exception.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            theCheckerboard.hasAtRightOf((Position)theRightPlayer);
            Assert.fail((String)"Expected an index out of bounds exception.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            theCheckerboard.hasAtBottomOf((Position)theBottomPlayer);
            Assert.fail((String)"Expected an index out of bounds exception.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            theCheckerboard.hasAtLeftOf((Position)theLeftPlayer);
            Assert.fail((String)"Expected an index out of bounds exception.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

