/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.CheckerboardImpl;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.TaitoImpl;
import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.Position;

public class CheckerboardTest {
    @Test
    public void testEvenCheckerboardPositions() {
        Checkerboard theCheckerboard = new CheckerboardImpl().withGridDimension(3, 3);
        TaitoImpl thePlayer = new TaitoImpl(1, 1);
        TaitoImpl theTopPlayer = new TaitoImpl(1, 0);
        TaitoImpl theLeftPlayer = new TaitoImpl(0, 1);
        TaitoImpl theBottomPlayer = new TaitoImpl(1, 2);
        TaitoImpl theRightPlayer = new TaitoImpl(2, 1);
        theCheckerboard.putPlayer((Player)theTopPlayer);
        theCheckerboard.putPlayer((Player)theLeftPlayer);
        theCheckerboard.putPlayer((Player)theBottomPlayer);
        theCheckerboard.putPlayer((Player)theRightPlayer);
        Assertions.assertTrue((boolean)theCheckerboard.hasAtTopOf((Position)thePlayer));
        Assertions.assertTrue((boolean)theCheckerboard.hasAtLeftOf((Position)thePlayer));
        Assertions.assertTrue((boolean)theCheckerboard.hasAtBottomOf((Position)thePlayer));
        Assertions.assertTrue((boolean)theCheckerboard.hasAtRightOf((Position)thePlayer));
        Assertions.assertFalse((boolean)theCheckerboard.hasAtTopLeftOf((Position)thePlayer));
        Assertions.assertFalse((boolean)theCheckerboard.hasAtBottomLeftOf((Position)thePlayer));
        Assertions.assertFalse((boolean)theCheckerboard.hasAtBottomRightOf((Position)thePlayer));
        Assertions.assertFalse((boolean)theCheckerboard.hasAtTopRightOf((Position)thePlayer));
        Assertions.assertEquals((Object)theTopPlayer, (Object)theCheckerboard.atTopOf((Position)thePlayer));
        Assertions.assertEquals((Object)theRightPlayer, (Object)theCheckerboard.atRightOf((Position)thePlayer));
        Assertions.assertEquals((Object)theBottomPlayer, (Object)theCheckerboard.atBottomOf((Position)thePlayer));
        Assertions.assertEquals((Object)theLeftPlayer, (Object)theCheckerboard.atLeftOf((Position)thePlayer));
        Assertions.assertNull((Object)theCheckerboard.atTopRightOf((Position)thePlayer));
        Assertions.assertNull((Object)theCheckerboard.atBottomRightOf((Position)thePlayer));
        Assertions.assertNull((Object)theCheckerboard.atBottomLeftOf((Position)thePlayer));
        Assertions.assertNull((Object)theCheckerboard.atTopLeftOf((Position)thePlayer));
    }

    @Test
    public void testOddCheckerboardPositions() {
        Checkerboard theCheckerboard = new CheckerboardImpl().withGridDimension(3, 3);
        TaitoImpl thePlayer = new TaitoImpl(1, 1);
        TaitoImpl theTopRightPlayer = new TaitoImpl(2, 0);
        TaitoImpl theBottomRightPlayer = new TaitoImpl(2, 2);
        TaitoImpl theBottomLeftPlayer = new TaitoImpl(0, 2);
        TaitoImpl theTopLeftPlayer = new TaitoImpl(0, 0);
        theCheckerboard.putPlayer((Player)theTopRightPlayer);
        theCheckerboard.putPlayer((Player)theBottomRightPlayer);
        theCheckerboard.putPlayer((Player)theBottomLeftPlayer);
        theCheckerboard.putPlayer((Player)theTopLeftPlayer);
        Assertions.assertFalse((boolean)theCheckerboard.hasAtTopOf((Position)thePlayer));
        Assertions.assertFalse((boolean)theCheckerboard.hasAtLeftOf((Position)thePlayer));
        Assertions.assertFalse((boolean)theCheckerboard.hasAtBottomOf((Position)thePlayer));
        Assertions.assertFalse((boolean)theCheckerboard.hasAtRightOf((Position)thePlayer));
        Assertions.assertTrue((boolean)theCheckerboard.hasAtTopLeftOf((Position)thePlayer));
        Assertions.assertTrue((boolean)theCheckerboard.hasAtBottomLeftOf((Position)thePlayer));
        Assertions.assertTrue((boolean)theCheckerboard.hasAtBottomRightOf((Position)thePlayer));
        Assertions.assertTrue((boolean)theCheckerboard.hasAtTopRightOf((Position)thePlayer));
        Assertions.assertEquals((Object)theTopRightPlayer, (Object)theCheckerboard.atTopRightOf((Position)thePlayer));
        Assertions.assertEquals((Object)theBottomRightPlayer, (Object)theCheckerboard.atBottomRightOf((Position)thePlayer));
        Assertions.assertEquals((Object)theBottomLeftPlayer, (Object)theCheckerboard.atBottomLeftOf((Position)thePlayer));
        Assertions.assertEquals((Object)theTopLeftPlayer, (Object)theCheckerboard.atTopLeftOf((Position)thePlayer));
        Assertions.assertNull((Object)theCheckerboard.atTopOf((Position)thePlayer));
        Assertions.assertNull((Object)theCheckerboard.atBottomOf((Position)thePlayer));
        Assertions.assertNull((Object)theCheckerboard.atLeftOf((Position)thePlayer));
        Assertions.assertNull((Object)theCheckerboard.atRightOf((Position)thePlayer));
    }

    @Test
    public void testPeriodicCheckerboardPositions() {
        Checkerboard theCheckerboard = (Checkerboard)new CheckerboardImpl().withGridDimension(3, 3).withGridMode(GridMode.PERIODIC);
        TaitoImpl theTopPlayer = new TaitoImpl(1, 0);
        TaitoImpl theLeftPlayer = new TaitoImpl(0, 1);
        TaitoImpl theBottomPlayer = new TaitoImpl(1, 2);
        TaitoImpl theRightPlayer = new TaitoImpl(2, 1);
        theCheckerboard.putPlayer((Player)theTopPlayer);
        theCheckerboard.putPlayer((Player)theLeftPlayer);
        theCheckerboard.putPlayer((Player)theBottomPlayer);
        theCheckerboard.putPlayer((Player)theRightPlayer);
        Assertions.assertTrue((boolean)theCheckerboard.hasAtBottomOf((Position)theBottomPlayer));
        Assertions.assertTrue((boolean)theCheckerboard.hasAtRightOf((Position)theRightPlayer));
        Assertions.assertTrue((boolean)theCheckerboard.hasAtBottomOf((Position)theBottomPlayer));
        Assertions.assertTrue((boolean)theCheckerboard.hasAtLeftOf((Position)theLeftPlayer));
    }

    @Test
    public void testClosedCheckerboardPositions() {
        Checkerboard theCheckerboard = (Checkerboard)new CheckerboardImpl().withGridDimension(3, 3).withGridMode(GridMode.CLOSED);
        TaitoImpl theTopPlayer = new TaitoImpl(1, 0);
        TaitoImpl theLeftPlayer = new TaitoImpl(0, 1);
        TaitoImpl theBottomPlayer = new TaitoImpl(1, 2);
        TaitoImpl theRightPlayer = new TaitoImpl(2, 1);
        theCheckerboard.putPlayer((Player)theTopPlayer);
        theCheckerboard.putPlayer((Player)theLeftPlayer);
        theCheckerboard.putPlayer((Player)theBottomPlayer);
        theCheckerboard.putPlayer((Player)theRightPlayer);
        try {
            theCheckerboard.hasAtBottomOf((Position)theBottomPlayer);
            Assertions.fail((String)"Expected an index out of bounds exception.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            theCheckerboard.hasAtRightOf((Position)theRightPlayer);
            Assertions.fail((String)"Expected an index out of bounds exception.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            theCheckerboard.hasAtBottomOf((Position)theBottomPlayer);
            Assertions.fail((String)"Expected an index out of bounds exception.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            theCheckerboard.hasAtLeftOf((Position)theLeftPlayer);
            Assertions.fail((String)"Expected an index out of bounds exception.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

