package org.refcodes.checkerboard;

import org.refcodes.graphical.Position;
import org.refcodes.graphical.Vector;

/**
 * The Interface ChangePositionEvent.
 *
 * @param <P> the generic type
 */
public interface ChangePositionEvent<P extends Player<P, ?>> extends PlayerEvent<P>, Position, Vector {

	PlayerAction ACTION = PlayerAction.CHANGE_POSITION;

	/**
	 * Gets the preceding position.
	 *
	 * @return the preceding position
	 */
	Position getPrecedingPosition();

}
