package org.refcodes.checkerboard;

import java.util.Map;
import java.util.function.Consumer;

import org.refcodes.component.Component;
import org.refcodes.graphical.GridDimension.GridDimensionBuilder;
import org.refcodes.graphical.GridDimension.GridDimensionProperty;
import org.refcodes.graphical.GridModeAccessor.GridModeBuilder;
import org.refcodes.graphical.GridModeAccessor.GridModeProperty;
import org.refcodes.graphical.Position;
import org.refcodes.observer.Observable;

/**
 * The Interface Checkerboard.
 *
 * @param <P> the generic type
 * @param <S> the generic type
 */
public interface Checkerboard<P extends Player<P, S>, S> extends Players<P>, Observable<CheckerboardObserver<P, S>>, GridDimensionProperty, GridDimensionBuilder<Checkerboard<P, S>>, GridModeProperty, GridModeBuilder<Checkerboard<P, S>>, Component {

	/**
	 * Checks for at position.
	 *
	 * @param aPos the pos
	 * 
	 * @return true, if successful
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	boolean hasAtPosition( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * Checks for at position.
	 *
	 * @param aPosX the pos X
	 * @param aPosY the pos Y
	 * 
	 * @return true, if successful
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	boolean hasAtPosition( int aPosX, int aPosY ) throws IndexOutOfBoundsException;

	/**
	 * At position.
	 *
	 * @param aPos the pos
	 * 
	 * @return the p
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	P atPosition( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * At position.
	 *
	 * @param aPosX the pos X
	 * @param aPosY the pos Y
	 * 
	 * @return the p
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	P atPosition( int aPosX, int aPosY ) throws IndexOutOfBoundsException;

	/**
	 * Gets the row.
	 *
	 * @param aRow the row
	 * 
	 * @return the row
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	Map<Integer, P> getRow( int aRow ) throws IndexOutOfBoundsException;

	/**
	 * Gets the column.
	 *
	 * @param aColumn the column
	 * 
	 * @return the column
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	Map<Integer, P> getColumn( int aColumn ) throws IndexOutOfBoundsException;

	/**
	 * Checks for at top of.
	 *
	 * @param aPos the pos
	 * 
	 * @return true, if successful
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	boolean hasAtTopOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * At top of.
	 *
	 * @param aPos the pos
	 * 
	 * @return the p
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	P atTopOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * Checks for at top right of.
	 *
	 * @param aPos the pos
	 * 
	 * @return true, if successful
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	boolean hasAtTopRightOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * At top right of.
	 *
	 * @param aPos the pos
	 * 
	 * @return the p
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	P atTopRightOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * Checks for at right of.
	 *
	 * @param aPos the pos
	 * 
	 * @return true, if successful
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	boolean hasAtRightOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * At right of.
	 *
	 * @param aPos the pos
	 * 
	 * @return the p
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	P atRightOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * Checks for at bottom right of.
	 *
	 * @param aPos the pos
	 * 
	 * @return true, if successful
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	boolean hasAtBottomRightOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * At bottom right of.
	 *
	 * @param aPos the pos
	 * 
	 * @return the p
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	P atBottomRightOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * Checks for at bottom of.
	 *
	 * @param aPos the pos
	 * 
	 * @return true, if successful
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	boolean hasAtBottomOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * At bottom of.
	 *
	 * @param aPos the pos
	 * 
	 * @return the p
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	P atBottomOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * Checks for at bottom left of.
	 *
	 * @param aPos the pos
	 * 
	 * @return true, if successful
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	boolean hasAtBottomLeftOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * At bottom left of.
	 *
	 * @param aPos the pos
	 * 
	 * @return the p
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	P atBottomLeftOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * Checks for at left of.
	 *
	 * @param aPos the pos
	 * 
	 * @return true, if successful
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	boolean hasAtLeftOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * At left of.
	 *
	 * @param aPos the pos
	 * 
	 * @return the p
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	P atLeftOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * Checks for at top left of.
	 *
	 * @param aPos the pos
	 * 
	 * @return true, if successful
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	boolean hasAtTopLeftOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * At top left of.
	 *
	 * @param aPos the pos
	 * 
	 * @return the p
	 * 
	 * @throws IndexOutOfBoundsException the index out of bounds exception
	 */
	P atTopLeftOf( Position aPos ) throws IndexOutOfBoundsException;

	/**
	 * Performs the given action for each {@link Player} on the
	 * {@link Checkerboard} until all players have been processed or the action
	 * throws an exception.
	 * 
	 * @param aConsumer The action to be performed for each {@link Player}.
	 */
	void forEach( Consumer<P> aConsumer );

}
