package org.refcodes.checkerboard;

import org.refcodes.exception.VetoException;
import org.refcodes.observer.ObservableObserver;

/**
 * An asynchronous update interface for receiving notifications about
 * Checkerboard information as the Checkerboard is constructed.
 *
 * @param <P> the generic type
 * @param <S> the generic type
 */
public interface CheckerboardObserver<P extends Player<P, S>, S> extends ObservableObserver<Checkerboard<P, S>> {

	/**
	 * This method is called when information about an Checkerboard which was
	 * previously requested using an asynchronous interface becomes available.
	 *
	 * @param aCheckerboardEvent the checkerboard event
	 */
	void onCheckerboardEvent( CheckerboardEvent<P, S> aCheckerboardEvent );

	/**
	 * This method is called when information about an Checkerboard which was
	 * previously requested using an asynchronous interface becomes available.
	 *
	 * @param aCheckerboardEvent the checkerboard event
	 */
	void onPlayerAddedEvent( PlayerAddedEvent<P, S> aCheckerboardEvent );

	/**
	 * This method is called when information about an Checkerboard which was
	 * previously requested using an asynchronous interface becomes available.
	 *
	 * @param aCheckerboardEvent the checkerboard event
	 */
	void onPlayerRemovedEvent( PlayerRemovedEvent<P, S> aCheckerboardEvent );

	/**
	 * This method is called when information about an Checkerboard which was
	 * previously requested using an asynchronous interface becomes available.
	 *
	 * @param aCheckerboardEvent the checkerboard event
	 */
	void onGridModeChangedEvent( GridModeChangedEvent<P, S> aCheckerboardEvent );

	/**
	 * This method is called when information about an Checkerboard which was
	 * previously requested using an asynchronous interface becomes available.
	 *
	 * @param aCheckerboardEvent the checkerboard event
	 */
	void onGridDimensionChangedEvent( GridDimensionChangedEvent<P, S> aCheckerboardEvent );

	/**
	 * This method is called when information about an Checkerboard which was
	 * previously requested using an asynchronous interface becomes available.
	 *
	 * @param aCheckerboardEvent the checkerboard event
	 */
	void onViewportOffsetChangedEvent( ViewportOffsetChangedEvent<P, S> aCheckerboardEvent );

	/**
	 * This method is called when information about an Checkerboard which was
	 * previously requested using an asynchronous interface becomes available.
	 *
	 * @param aCheckerboardEvent the checkerboard event
	 */
	void onViewportDimensionChangedEvent( ViewportDimensionChangedEvent<P, S> aCheckerboardEvent );

	/**
	 * This method is called when information about an Checkerboard which was
	 * previously requested using an asynchronous interface becomes available.
	 *
	 * @param aPlayerEvent the player event
	 * @param aSource The according source (origin).
	 */
	void onPlayerEvent( PlayerEvent<P> aPlayerEvent, Checkerboard<P, S> aSource );

	/**
	 * This method is called when information about an Checkerboard which was
	 * previously requested using an asynchronous interface becomes available.
	 *
	 * @param aPlayerEvent the player event
	 * @param aSource The according source (origin).
	 * 
	 * @throws VetoException the veto exception
	 */
	void onChangePositionEvent( ChangePositionEvent<P> aPlayerEvent, Checkerboard<P, S> aSource ) throws VetoException;

	/**
	 * This method is called when information about an Checkerboard which was
	 * previously requested using an asynchronous interface becomes available.
	 *
	 * @param aPlayerEvent the player event
	 * @param aSource The according source (origin).
	 */
	void onPositionChangedEvent( PositionChangedEvent<P> aPlayerEvent, Checkerboard<P, S> aSource );

	/**
	 * This method is called when information about an Checkerboard which was
	 * previously requested using an asynchronous interface becomes available.
	 *
	 * @param aPlayerEvent the player event
	 * @param aSource The according source (origin).
	 */
	void onStateChangedEvent( StateChangedEvent<P, S> aPlayerEvent, Checkerboard<P, S> aSource );

	/**
	 * This method is called when information about an Checkerboard which was
	 * previously requested using an asynchronous interface becomes available.
	 *
	 * @param aPlayerEvent the player event
	 * @param aSource The according source (origin).
	 */
	void onVisibilityChangedEvent( VisibilityChangedEvent<P> aPlayerEvent, Checkerboard<P, S> aSource );

	/**
	 * This method is called when information about an Checkerboard which was
	 * previously requested using an asynchronous interface becomes available.
	 *
	 * @param aPlayerEvent the player event
	 * @param aSource The according source (origin).
	 */
	void onDraggabilityChangedEvent( DraggabilityChangedEvent<P> aPlayerEvent, Checkerboard<P, S> aSource );
}
