package org.refcodes.checkerboard;

import org.refcodes.graphical.GridDimension;

/**
 * The Interface GridDimensionChangedEvent.
 *
 * @param <P> the generic type
 * @param <S> the generic type
 */
public interface GridDimensionChangedEvent<P extends Player<P, S>, S> extends CheckerboardEvent<P, S>, GridDimension {

	CheckerboardAction ACTION = CheckerboardAction.GRID_DIMENSION_CHANGED;

	/**
	 * Gets the preceding grid dimension.
	 *
	 * @return the preceding grid dimension
	 */
	GridDimension getPrecedingGridDimension();
}