package org.refcodes.checkerboard;

import org.refcodes.graphical.GridDimension;
import org.refcodes.graphical.GridDimensionImpl;

/**
 * The Class GridDimensionChangedEventImpl.
 *
 * @param <P> the generic type
 * @param <S> the generic type
 */
public class GridDimensionChangedEventImpl<P extends Player<P, S>, S> extends AbstractCheckerboardEvent<P, S> implements GridDimensionChangedEvent<P, S> {

	private int _height;

	private int _width;

	private GridDimension _precedingDimension;

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new grid dimension changed event.
	 *
	 * @param aWidth the width
	 * @param aHeight the height
	 * @param aPrecedingWidth the preceding width
	 * @param aPrecedingHeigt the preceding heigt
	 * @param aSource The according source (origin).
	 */
	public GridDimensionChangedEventImpl( int aWidth, int aHeight, int aPrecedingWidth, int aPrecedingHeigt, Checkerboard<P, S> aSource ) {
		super( ACTION, aSource );
		_width = aWidth;
		_height = aHeight;
		_precedingDimension = new GridDimensionImpl( aPrecedingWidth, aPrecedingHeigt );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getGridHeight() {
		return _height;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getGridWidth() {
		return _width;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public GridDimension getPrecedingGridDimension() {
		return _precedingDimension;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return getClass().getSimpleName() + "(" + _width + ":" + _height + ")@" + hashCode();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
