package org.refcodes.checkerboard;

import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.GridModeAccessor;

/**
 * The Interface GridModeChangedEvent.
 *
 * @param <P> the generic type
 * @param <S> the generic type
 */
public interface GridModeChangedEvent<P extends Player<P, S>, S> extends CheckerboardEvent<P, S>, GridModeAccessor {

	CheckerboardAction ACTION = CheckerboardAction.GRID_MODE_CHANGED;

	/**
	 * Gets the preceding grid mode.
	 *
	 * @return the preceding grid mode
	 */
	GridMode getPrecedingGridMode();

}
