package org.refcodes.checkerboard;

import org.refcodes.graphical.GridMode;

/**
 * The Class GridModeChangedEventImpl.
 *
 * @param <P> the generic type
 * @param <S> the generic type
 */
public class GridModeChangedEventImpl<P extends Player<P, S>, S> extends AbstractCheckerboardEvent<P, S> implements GridModeChangedEvent<P, S> {

	private GridMode _gridMode;

	private GridMode _precedingGridMode;

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new grid mode changed event.
	 *
	 * @param aGridMode the grid mode
	 * @param aPrecedingGridMode the preceding grid mode
	 * @param aSource The according source (origin).
	 */
	public GridModeChangedEventImpl( GridMode aGridMode, GridMode aPrecedingGridMode, Checkerboard<P, S> aSource ) {
		super( ACTION, aSource );
		_gridMode = aGridMode;
		_precedingGridMode = aPrecedingGridMode;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public GridMode getGridMode() {
		return _gridMode;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public GridMode getPrecedingGridMode() {
		return _precedingGridMode;
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
