package org.refcodes.checkerboard;

import org.refcodes.exception.VetoException;

/**
 * An asynchronous update interface for receiving notifications about Player
 * information as the Player is constructed.
 *
 * @param <P> the generic type
 * @param <S> the generic type
 */
@FunctionalInterface
public interface PlayerObserver<P extends Player<P, S>, S> extends ClickedObserver<P>, ChangePositionObserver<P>, PositionChangedObserver<P>, StateChangedObserver<P, S>, VisibilityChangedObserver<P>, DraggabilityChangedObserver<P> {

	/**
	 * This method is called when information about an Player which was
	 * previously requested using an asynchronous interface becomes available.
	 *
	 * @param aPlayerEvent the player event
	 */
	void onPlayerEvent( PlayerEvent<P> aPlayerEvent );

	/**
	 * {@inheritDoc}
	 */
	@Override
	default void onChangePositionEvent( ChangePositionEvent<P> aPlayerEvent ) throws VetoException {}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default void onPositionChangedEvent( PositionChangedEvent<P> aPlayerEvent ) {}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default void onStateChangedEvent( StateChangedEvent<P, S> aPlayerEvent ) {}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default void onVisibilityChangedEvent( VisibilityChangedEvent<P> aPlayerEvent ) {}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default void onDraggabilityChangedEvent( DraggabilityChangedEvent<P> aPlayerEvent ) {}

	/**
	 * {@inheritDoc}
	 */
	@Override
	default void onClickedEvent( ClickedEvent<P> aPlayerEvent ) {}
}
