// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.checkerboard;

import java.util.Iterator;
import java.util.List;

/**
 * The Interface Players.
 *
 * @author steiner
 * 
 * @param <P> the generic type
 */
public interface Players<P extends Player<P, ?>> {

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Gets the players.
	 *
	 * @return the players
	 */
	public List<P> getPlayers();

	/**
	 * Players.
	 *
	 * @return the iterator
	 */
	public Iterator<P> players();

	/**
	 * Checks for player.
	 *
	 * @param aElement the element
	 * 
	 * @return true, if successful
	 */
	public boolean hasPlayer( P aElement );

	/**
	 * Player count.
	 *
	 * @return the int
	 */
	public int playerCount();

	/**
	 * Checks for players.
	 *
	 * @return true, if successful
	 */
	public boolean hasPlayers();

	/**
	 * Clear players.
	 */
	public void clearPlayers();

	/**
	 * Put player.
	 *
	 * @param aElement the element
	 * 
	 * @return the p
	 */
	public P putPlayer( P aElement );

	/**
	 * Removes the player.
	 *
	 * @param aElement the element
	 * 
	 * @return true, if successful
	 */
	public boolean removePlayer( P aElement );

}
