package org.refcodes.checkerboard;

import org.refcodes.graphical.Position;
import org.refcodes.graphical.Vector;

/**
 * The Interface PositionChangedEvent.
 *
 * @param <P> the generic type
 */
public interface PositionChangedEvent<P extends Player<P, ?>> extends PlayerEvent<P>, Position, Vector {

	PlayerAction ACTION = PlayerAction.POSITION_CHANGED;

	/**
	 * Gets the preceding position.
	 *
	 * @return the preceding position
	 */
	Position getPrecedingPosition();

}
