package org.refcodes.checkerboard;

import org.refcodes.graphical.Position;
import org.refcodes.graphical.PositionImpl;

/**
 * The Class PositionChangedEventImpl.
 *
 * @param <P> the generic type
 */
public class PositionChangedEventImpl<P extends Player<P, ?>> extends AbstractPlayerEvent<P> implements PositionChangedEvent<P> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private int _posX;

	private int _posY;

	private Position _precedingPosition;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new position changed event.
	 *
	 * @param aPosX the pos X
	 * @param aPosY the pos Y
	 * @param aPrePosX the pre pos X
	 * @param aPrePosY the pre pos Y
	 * @param aSource The according source (origin).
	 */
	public PositionChangedEventImpl( int aPosX, int aPosY, int aPrePosX, int aPrePosY, P aSource ) {
		super( ACTION, aSource );
		_posX = aPosX;
		_posY = aPosY;
		_precedingPosition = new PositionImpl( aPrePosX, aPrePosY );
	}

	/**
	 * Instantiates a new position changed event.
	 *
	 * @param aPosition the position
	 * @param aPrecedingPosition the preceding position
	 * @param aSource The according source (origin).
	 */
	public PositionChangedEventImpl( Position aPosition, Position aPrecedingPosition, P aSource ) {
		super( ACTION, aSource );
		_posX = aPosition.getPositionX();
		_posY = aPosition.getPositionY();
		_precedingPosition = aPrecedingPosition;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Position getPrecedingPosition() {
		return _precedingPosition;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getPositionX() {
		return _posX;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getPositionY() {
		return _posY;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getVectorX() {
		return _posX - _precedingPosition.getPositionX();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getVectorY() {
		return _posY - _precedingPosition.getPositionY();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return super.toString() + ", x := " + _posX + ", y := " + _posY + " (state before: " + _precedingPosition + ")";
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
