package org.refcodes.checkerboard;

import org.refcodes.mixin.StatusAccessor;

/**
 * The Interface StateChangedEvent.
 *
 * @param <P> the generic type
 * @param <S> The state if the player (dead, alive, strong, weak, king, queen,
 *        PacMan, ghost, fire, wood, water, strong queen, weak king, etc).
 */
public interface StateChangedEvent<P extends Player<P, S>, S> extends PlayerEvent<P>, StatusAccessor<S> {

	PlayerAction ACTION = PlayerAction.STATE_CHANGED;

	/**
	 * Gets the preceding state.
	 *
	 * @return the preceding state
	 */
	S getPrecedingState();

}
