package org.refcodes.checkerboard;

/**
 * The Class StateChangedEventImpl.
 *
 * @param <P> the generic type
 * @param <S> the generic type
 */
public class StateChangedEventImpl<P extends Player<P, S>, S> extends AbstractPlayerEvent<P> implements StateChangedEvent<P, S> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private S _state;

	private S _precedingState;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new state changed event.
	 *
	 * @param aState the state
	 * @param aPrecedingState the preceding state
	 * @param aSource The according source (origin).
	 */
	public StateChangedEventImpl( S aState, S aPrecedingState, P aSource ) {
		super( ACTION, aSource );
		_state = aState;
		_precedingState = aPrecedingState;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public S getStatus() {
		return _state;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public S getPrecedingState() {
		return _precedingState;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return super.toString() + ", state := " + _state + " (state before: " + _precedingState + ")";
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
