// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.checkerboard;

/**
 * "... The use of sprites originated with arcade games. The first video game to
 * represent player characters as human player images was Taito's Basketball,
 * which was licensed in February 1974 to Midway, releasing it as TV Basketball
 * in North America ..." (Wikipedia) As the {@link GraphicalCheckerboardViewer}
 * handles {@link Player} instances in terms of "sprites", the most basic
 * directly usable {@link Player} type is the {@link Taito}, named after the
 * company being the first one representing players in a game by sprites.
 *
 * @param <S> the generic type
 * 
 * @see "https://en.wikipedia.org/wiki/Sprite_(computer_graphics)"
 */
public interface Taito<S> extends Player<Taito<S>, S> {}
