package org.refcodes.checkerboard;

import org.refcodes.graphical.ViewportDimension;
import org.refcodes.graphical.ViewportOffset;

/**
 * The Interface ViewportDimensionChangedEvent.
 *
 * @param <P> the generic type
 * @param <S> the generic type
 */
public interface ViewportDimensionChangedEvent<P extends Player<P, S>, S> extends CheckerboardViewerEvent<P, S>, ViewportDimension {

	CheckerboardViewerAction ACTION = CheckerboardViewerAction.VIEWPORT_DIMENSION_CHANGED;

	/**
	 * Gets the preceding viewport dimension.
	 *
	 * @return the preceding viewport dimension
	 */
	ViewportDimension getPrecedingViewportDimension();

	/**
	 * Gets the viewport offset.
	 *
	 * @return the viewport offset
	 */
	ViewportOffset getViewportOffset();

}
