package org.refcodes.checkerboard;

import org.refcodes.graphical.ViewportDimension;
import org.refcodes.graphical.ViewportDimensionImpl;
import org.refcodes.graphical.ViewportOffset;
import org.refcodes.graphical.ViewportOffsetImpl;

/**
 * The Class ViewportDimensionChangedEventImpl.
 *
 * @param <P> the generic type
 * @param <S> the generic type
 */
public class ViewportDimensionChangedEventImpl<P extends Player<P, S>, S> extends AbstractCheckerboardViewerEvent<P, S> implements ViewportDimensionChangedEvent<P, S> {

	private int _height;

	private int _width;

	private ViewportDimension _precedingDimension;

	private ViewportOffset _viewportOffset;

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new viewport dimension changed event.
	 *
	 * @param aWidth the width
	 * @param aHeight the height
	 * @param aPrecedingWidth the preceding width
	 * @param aPrecedingHeigt the preceding heigt
	 * @param aOffsetX the offset X
	 * @param aOffsetY the offset Y
	 * @param aSource The according source (origin).
	 */
	public ViewportDimensionChangedEventImpl( int aWidth, int aHeight, int aPrecedingWidth, int aPrecedingHeigt, int aOffsetX, int aOffsetY, CheckerboardViewer<P, S, ?> aSource ) {
		super( ACTION, aSource );
		_width = aWidth;
		_height = aHeight;
		_precedingDimension = new ViewportDimensionImpl( aPrecedingWidth, aPrecedingHeigt );
		_viewportOffset = new ViewportOffsetImpl( aOffsetX, aOffsetY );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getViewportHeight() {
		return _height;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getViewportWidth() {
		return _width;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ViewportDimension getPrecedingViewportDimension() {
		return _precedingDimension;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ViewportOffset getViewportOffset() {
		return _viewportOffset;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return getClass().getSimpleName() + "(" + _width + ":" + _height + ")@" + hashCode();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
