package org.refcodes.checkerboard;

import org.refcodes.graphical.ViewportOffset;

/**
 * The Interface ViewportOffsetChangedEvent.
 *
 * @param <P> the generic type
 * @param <S> the generic type
 */
public interface ViewportOffsetChangedEvent<P extends Player<P, S>, S> extends CheckerboardViewerEvent<P, S>, ViewportOffset {

	CheckerboardViewerAction ACTION = CheckerboardViewerAction.VIEWPORT_OFFSET_CHANGED;

	/**
	 * Gets the preceding viewport offset.
	 *
	 * @return the preceding viewport offset
	 */
	ViewportOffset getPrecedingViewportOffset();

}
