package org.refcodes.checkerboard;

import org.refcodes.graphical.ViewportOffset;
import org.refcodes.graphical.ViewportOffsetImpl;

/**
 * The Class ViewportOffsetChangedEventImpl.
 *
 * @param <P> the generic type
 * @param <S> the generic type
 */
public class ViewportOffsetChangedEventImpl<P extends Player<P, S>, S> extends AbstractCheckerboardViewerEvent<P, S> implements ViewportOffsetChangedEvent<P, S> {

	private int _offsetX;

	private int _offsetY;

	private ViewportOffset _precedingOffset;

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new viewport offset changed event.
	 *
	 * @param aOffsetY the offset Y
	 * @param aOffsetX the offset X
	 * @param aPrecedingOffsetX the preceding offset X
	 * @param aPrecedingOffsetY the preceding offset Y
	 * @param aSource The according source (origin).
	 */
	public ViewportOffsetChangedEventImpl( int aOffsetY, int aOffsetX, int aPrecedingOffsetX, int aPrecedingOffsetY, CheckerboardViewer<P, S, ?> aSource ) {
		super( ACTION, aSource );
		_offsetX = aOffsetX;
		_offsetY = aOffsetY;
		_precedingOffset = new ViewportOffsetImpl( aPrecedingOffsetX, aPrecedingOffsetY );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getViewportOffsetX() {
		return _offsetX;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getViewportOffsetY() {
		return _offsetY;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ViewportOffset getPrecedingViewportOffset() {
		return _precedingOffset;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return getClass().getSimpleName() + "(" + _offsetX + ":" + _offsetY + ")@" + hashCode();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
