// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.checkerboard;

/**
 * Visibility changed event observer.
 */
@FunctionalInterface
public interface VisibilityChangedObserver<P extends Player<P, ?>> {

	/**
	 * This method is called when information about an Player which was
	 * previously requested using an asynchronous interface becomes available.
	 *
	 * @param aPlayerEvent the player event
	 */
	void onVisibilityChangedEvent( VisibilityChangedEvent<P> aPlayerEvent );

}
