/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.refcodes.checkerboard.ChangePlayerPositionEvent;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.CheckerboardEvent;
import org.refcodes.checkerboard.CheckerboardObserver;
import org.refcodes.checkerboard.GridDimensionChangedEvent;
import org.refcodes.checkerboard.GridModeChangedEvent;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.PlayerAddedEvent;
import org.refcodes.checkerboard.PlayerDraggabilityChangedEvent;
import org.refcodes.checkerboard.PlayerEvent;
import org.refcodes.checkerboard.PlayerObserver;
import org.refcodes.checkerboard.PlayerPositionChangedEvent;
import org.refcodes.checkerboard.PlayerRemovedEvent;
import org.refcodes.checkerboard.PlayerStateChangedEvent;
import org.refcodes.checkerboard.PlayerVisibilityChangedEvent;
import org.refcodes.checkerboard.ViewportDimensionChangedEvent;
import org.refcodes.checkerboard.ViewportOffsetChangedEvent;
import org.refcodes.controlflow.ExecutionStrategy;
import org.refcodes.exception.VetoException;
import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.GridDimension;
import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.Position;
import org.refcodes.graphical.PositionImpl;
import org.refcodes.observer.AbstractObservable;
import org.refcodes.observer.Event;
import org.refcodes.observer.SubscribeEvent;
import org.refcodes.observer.UnsubscribeEvent;

public abstract class AbstractCheckerboard<T extends Checkerboard<P, S>, P extends Player<P, S>, S>
extends AbstractObservable<CheckerboardObserver<P, S>, Event<?>>
implements Checkerboard<P, S> {
    private final List<P> _players = new ArrayList<P>();
    private final Map<Integer, Map<Integer, P>> _rowToColumn = new HashMap<Integer, Map<Integer, P>>();
    private final Map<Integer, Map<Integer, P>> _columnToRow = new HashMap<Integer, Map<Integer, P>>();
    private int _gridWidth = -1;
    private int _gridHeight = -1;
    private GridMode _gridMode = GridMode.NONE;
    private final CheckerboardPlayerObserverImpl _observer = new CheckerboardPlayerObserverImpl();

    public T withGridMode(GridMode aGridMode) {
        this.setGridMode(aGridMode);
        return (T)this;
    }

    public T withGridDimension(int aGridWidth, int aGridHeight) {
        this.setGridDimension(aGridWidth, aGridHeight);
        return (T)this;
    }

    public T withGridDimension(GridDimension aDimension) {
        this.setGridDimension(aDimension);
        return (T)this;
    }

    public T withGridDimension(Dimension aDimension) {
        this.setGridDimension(aDimension);
        return (T)this;
    }

    public T withGridWidth(int aWidth) {
        this.setGridWidth(aWidth);
        return (T)this;
    }

    public T withGridHeight(int aHeight) {
        this.setGridHeight(aHeight);
        return (T)this;
    }

    @Override
    public void forEach(Consumer<P> aConsumer) {
        new ArrayList<P>(this._players).forEach(aConsumer);
    }

    @Override
    public boolean hasAtPosition(Position aPos) {
        return this.hasAtPosition(aPos.getPositionX(), aPos.getPositionY());
    }

    @Override
    public boolean hasAtPosition(int aPosX, int aPosY) {
        Position thePos = this.toAbsPos(aPosX, aPosY);
        Map<Integer, P> theColumn = this._rowToColumn.get(thePos.getPositionX());
        if (theColumn != null) {
            return theColumn.containsKey(thePos.getPositionY());
        }
        return false;
    }

    @Override
    public P atPosition(Position aPos) {
        return this.atPosition(aPos.getPositionX(), aPos.getPositionY());
    }

    @Override
    public P atPosition(int aPosX, int aPosY) {
        Position thePos = this.toAbsPos(aPosX, aPosY);
        Map<Integer, P> theColumn = this._rowToColumn.get(thePos.getPositionX());
        if (theColumn != null) {
            return (P)((Player)theColumn.get(thePos.getPositionY()));
        }
        return null;
    }

    @Override
    public boolean hasAtTopOf(Position aPos) {
        int x = aPos.getPositionX();
        int y = this.toTopYPosition(aPos);
        return this.hasAtPosition(x, y);
    }

    @Override
    public P atTopOf(Position aPos) {
        int x = aPos.getPositionX();
        int y = this.toTopYPosition(aPos);
        return this.atPosition(x, y);
    }

    @Override
    public boolean hasAtTopRightOf(Position aPos) {
        int y = this.toTopYPosition(aPos);
        int x = this.toRightXPosition(aPos);
        return this.hasAtPosition(x, y);
    }

    @Override
    public P atTopRightOf(Position aPos) {
        int y = this.toTopYPosition(aPos);
        int x = this.toRightXPosition(aPos);
        return this.atPosition(x, y);
    }

    @Override
    public boolean hasAtRightOf(Position aPos) {
        int y = aPos.getPositionY();
        int x = this.toRightXPosition(aPos);
        return this.hasAtPosition(x, y);
    }

    @Override
    public P atRightOf(Position aPos) {
        int y = aPos.getPositionY();
        int x = this.toRightXPosition(aPos);
        return this.atPosition(x, y);
    }

    @Override
    public boolean hasAtBottomRightOf(Position aPos) {
        int y = this.toBottomYPosition(aPos);
        int x = this.toRightXPosition(aPos);
        return this.hasAtPosition(x, y);
    }

    @Override
    public P atBottomRightOf(Position aPos) {
        int y = this.toBottomYPosition(aPos);
        int x = this.toRightXPosition(aPos);
        return this.atPosition(x, y);
    }

    @Override
    public boolean hasAtBottomOf(Position aPos) {
        int x = aPos.getPositionX();
        int y = this.toBottomYPosition(aPos);
        return this.hasAtPosition(x, y);
    }

    @Override
    public P atBottomOf(Position aPos) {
        int x = aPos.getPositionX();
        int y = this.toBottomYPosition(aPos);
        return this.atPosition(x, y);
    }

    @Override
    public boolean hasAtBottomLeftOf(Position aPos) {
        int y = this.toBottomYPosition(aPos);
        int x = this.toLeftXPosition(aPos);
        return this.hasAtPosition(x, y);
    }

    @Override
    public P atBottomLeftOf(Position aPos) {
        int y = this.toBottomYPosition(aPos);
        int x = this.toLeftXPosition(aPos);
        return this.atPosition(x, y);
    }

    @Override
    public boolean hasAtLeftOf(Position aPos) {
        int y = aPos.getPositionY();
        int x = this.toLeftXPosition(aPos);
        return this.hasAtPosition(x, y);
    }

    @Override
    public P atLeftOf(Position aPos) {
        int y = aPos.getPositionY();
        int x = this.toLeftXPosition(aPos);
        return this.atPosition(x, y);
    }

    @Override
    public boolean hasAtTopLeftOf(Position aPos) {
        int y = this.toTopYPosition(aPos);
        int x = this.toLeftXPosition(aPos);
        return this.hasAtPosition(x, y);
    }

    @Override
    public P atTopLeftOf(Position aPos) {
        int y = this.toTopYPosition(aPos);
        int x = this.toLeftXPosition(aPos);
        return this.atPosition(x, y);
    }

    @Override
    public Map<Integer, P> getRow(int aRow) {
        return this._rowToColumn.get(aRow);
    }

    @Override
    public Map<Integer, P> getColumn(int aColumn) {
        return this._columnToRow.get(aColumn);
    }

    public GridMode getGridMode() {
        return this._gridMode;
    }

    public void setGridMode(GridMode aGridMode) {
        if (aGridMode != this._gridMode) {
            GridModeChangedEvent theEvent = new GridModeChangedEvent(aGridMode, this._gridMode, this);
            this._gridMode = aGridMode;
            try {
                this.fireEvent(theEvent, ExecutionStrategy.SEQUENTIAL);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    @Override
    public List<P> getPlayers() {
        return this._players;
    }

    @Override
    public P putPlayer(P aPlayer) {
        this._players.add(aPlayer);
        P thePrevPlayer = this.atPosition((Position)aPlayer);
        if (thePrevPlayer != null && !this.removePlayer(thePrevPlayer)) {
            throw new IllegalStateException("Illegal state detected while replacing player \"" + thePrevPlayer + "> from position (" + thePrevPlayer.getPositionX() + ":" + aPlayer.getPositionY() + ") with player player \"" + aPlayer + "> from position (" + aPlayer.getPositionX() + ":" + aPlayer.getPositionY() + "). Probably the player's coordinates changed while removing.");
        }
        if (this.addToLookup(aPlayer) != null) {
            throw new IllegalStateException("Illegal state detected while removing player \"" + aPlayer + "> from position (" + aPlayer.getPositionX() + ":" + aPlayer.getPositionY() + "). Probably the player's coordinates changed while removing.");
        }
        PlayerAddedEvent theEvent = new PlayerAddedEvent(aPlayer, this);
        aPlayer.subscribeObserver((Object)this._observer);
        try {
            this.fireEvent(theEvent, ExecutionStrategy.SEQUENTIAL);
        }
        catch (VetoException vetoException) {
            // empty catch block
        }
        return thePrevPlayer;
    }

    @Override
    public boolean removePlayer(P aPlayer) {
        if (this._players.remove(aPlayer)) {
            if (this.removeFromLookup((Position)aPlayer) != aPlayer) {
                throw new IllegalStateException("Illegal state detected while removing player \"" + aPlayer + "> from position (" + aPlayer.getPositionX() + ":" + aPlayer.getPositionY() + "). Probably the player's coordinates changed while removing.");
            }
            PlayerRemovedEvent theEvent = new PlayerRemovedEvent(aPlayer, this);
            aPlayer.unsubscribeObserver((Object)this._observer);
            aPlayer.subscribeObserver((Object)this._observer);
            try {
                this.fireEvent(theEvent, ExecutionStrategy.SEQUENTIAL);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public void clearPlayers() {
        this._players.clear();
    }

    @Override
    public int playerCount() {
        return this._players.size();
    }

    @Override
    public boolean hasPlayers() {
        return !this._players.isEmpty();
    }

    @Override
    public Iterator<P> players() {
        return this._players.iterator();
    }

    @Override
    public boolean hasPlayer(P aPlayer) {
        return this._players.contains(aPlayer);
    }

    public int getGridWidth() {
        return this._gridWidth;
    }

    public void setGridDimension(int aWidth, int aHeight) {
        if (aWidth != this._gridWidth || aHeight != this._gridHeight) {
            GridDimensionChangedEvent theEvent = new GridDimensionChangedEvent(aWidth, aHeight, this._gridWidth, this._gridHeight, this);
            this._gridWidth = aWidth;
            this._gridHeight = aHeight;
            try {
                this.fireEvent(theEvent, ExecutionStrategy.SEQUENTIAL);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    public void setGridDimension(GridDimension aDimension) {
        this.setGridDimension(aDimension.getGridWidth(), aDimension.getGridHeight());
    }

    public void setGridDimension(Dimension aDimension) {
        this.setGridDimension(aDimension.getWidth(), aDimension.getHeight());
    }

    public void setGridWidth(int aWidth) {
        this.setGridDimension(aWidth, this._gridHeight);
    }

    public void setGridHeight(int aHeight) {
        this.setGridDimension(this._gridWidth, aHeight);
    }

    public int getGridHeight() {
        return this._gridHeight;
    }

    public boolean subscribeObserver(CheckerboardObserver<P, S> aObserver) {
        if (super.subscribeObserver(aObserver)) {
            try {
                this.fireEvent(new SubscribeEvent((Object)this), ExecutionStrategy.SEQUENTIAL);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public boolean unsubscribeObserver(CheckerboardObserver<P, S> aObserver) {
        try {
            this.fireEvent(new UnsubscribeEvent((Object)this), ExecutionStrategy.SEQUENTIAL);
        }
        catch (VetoException vetoException) {
            // empty catch block
        }
        return super.unsubscribeObserver(aObserver);
    }

    public void destroy() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._players == null ? 0 : this._players.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCheckerboard other = (AbstractCheckerboard)obj;
        return !(this._players == null ? other._players != null : !this._players.equals(other._players));
    }

    protected boolean fireEvent(Event<?> aEvent, CheckerboardObserver<P, S> aObserver, ExecutionStrategy aExecutionStrategy) throws VetoException {
        if (aEvent instanceof SubscribeEvent) {
            aObserver.onSubscribe((SubscribeEvent)aEvent);
        }
        if (aEvent instanceof UnsubscribeEvent) {
            aObserver.onUnsubscribe((UnsubscribeEvent)aEvent);
        }
        if (aEvent instanceof CheckerboardEvent) {
            aObserver.onCheckerboardEvent((CheckerboardEvent)aEvent);
            if (aEvent instanceof PlayerAddedEvent) {
                aObserver.onPlayerAddedEvent((PlayerAddedEvent)aEvent);
            }
            if (aEvent instanceof PlayerRemovedEvent) {
                aObserver.onPlayerRemovedEvent((PlayerRemovedEvent)aEvent);
            }
            if (aEvent instanceof GridModeChangedEvent) {
                aObserver.onGridModeChangedEvent((GridModeChangedEvent)aEvent);
            }
            if (aEvent instanceof ViewportDimensionChangedEvent) {
                aObserver.onViewportDimensionChangedEvent((ViewportDimensionChangedEvent)aEvent);
            }
            if (aEvent instanceof ViewportOffsetChangedEvent) {
                aObserver.onViewportOffsetChangedEvent((ViewportOffsetChangedEvent)aEvent);
            }
        } else if (aEvent instanceof PlayerEvent) {
            aObserver.onPlayerEvent((PlayerEvent)aEvent, this);
            if (aEvent instanceof ChangePlayerPositionEvent) {
                aObserver.onChangePlayerPositionEvent((ChangePlayerPositionEvent)aEvent, this);
            }
            if (aEvent instanceof PlayerPositionChangedEvent) {
                aObserver.onPlayerPositionChangedEvent((PlayerPositionChangedEvent)aEvent, this);
            }
            if (aEvent instanceof PlayerStateChangedEvent) {
                aObserver.onPlayerStateChangedEvent((PlayerStateChangedEvent)aEvent, this);
            }
            if (aEvent instanceof PlayerVisibilityChangedEvent) {
                aObserver.onPlayerVisibilityChangedEvent((PlayerVisibilityChangedEvent)aEvent, this);
            }
            if (aEvent instanceof PlayerDraggabilityChangedEvent) {
                aObserver.onPlayerDraggabilityChangedEvent((PlayerDraggabilityChangedEvent)aEvent, this);
            }
        }
        return true;
    }

    private Position toAbsPos(int aPosX, int aPosY) {
        if (this.getGridMode() == GridMode.PERIODIC) {
            while (aPosX < 0) {
                aPosX += this.getGridWidth();
            }
            while (aPosY < 0) {
                aPosY += this.getGridHeight();
            }
            while (aPosX >= this.getGridWidth()) {
                aPosX -= this.getGridWidth();
            }
            while (aPosY >= this.getGridHeight()) {
                aPosY -= this.getGridHeight();
            }
        }
        PositionImpl thePos = new PositionImpl(aPosX, aPosY);
        return thePos;
    }

    private synchronized P removeFromLookup(Position aPosition) {
        Player removeFromRow = null;
        Map<Integer, P> theColumn = this._rowToColumn.get(aPosition.getPositionX());
        if (theColumn != null) {
            removeFromRow = (Player)theColumn.remove(aPosition.getPositionY());
        }
        Player removeFromColumn = null;
        Map<Integer, P> theRow = this._columnToRow.get(aPosition.getPositionY());
        if (theRow != null) {
            removeFromColumn = (Player)theRow.remove(aPosition.getPositionX());
        }
        if (removeFromColumn != removeFromRow) {
            throw new IllegalStateException("Illegal state detected while removing player \"" + aPosition + "> from position (" + aPosition.getPositionX() + ":" + aPosition.getPositionY() + "). Probably the player's coordinates changed while removing.");
        }
        return (P)removeFromColumn;
    }

    private synchronized P addToLookup(P aPlayer) {
        Player theAddFromRow = null;
        Map<Integer, P> theColumn = this._rowToColumn.get(aPlayer.getPositionX());
        if (theColumn == null) {
            theColumn = new HashMap<Integer, P>();
            this._rowToColumn.put(aPlayer.getPositionX(), theColumn);
        }
        theAddFromRow = (Player)theColumn.put(aPlayer.getPositionY(), aPlayer);
        Player theAddFromColumn = null;
        Map<Integer, P> theRow = this._columnToRow.get(aPlayer.getPositionY());
        if (theRow == null) {
            theRow = new HashMap<Integer, P>();
            this._columnToRow.put(aPlayer.getPositionY(), theRow);
        }
        if ((theAddFromColumn = (Player)theRow.put(aPlayer.getPositionX(), aPlayer)) != theAddFromRow) {
            throw new IllegalStateException("Illegal state detected while removing player \"" + aPlayer + "> from position (" + aPlayer.getPositionX() + ":" + aPlayer.getPositionY() + "). Probably the player's coordinates changed while removing.");
        }
        return (P)theAddFromColumn;
    }

    private P updatePlayer(P aPlayer, Position aPrecedingPosition) {
        P theReplacedPlayer = this.atPosition((Position)aPlayer);
        this.removePlayer(theReplacedPlayer);
        P theTmpPlayer = this.addToLookup(aPlayer);
        if (theTmpPlayer != null) {
            throw new IllegalStateException("Illegal state detected while moving player \"" + aPlayer + "> from position (" + aPrecedingPosition.toString() + "): The target position (although being cleared before) now contains another player \"" + theTmpPlayer + ">. Probably some thread race condition and insufficient synchronization.");
        }
        P thePrevPlayerPos = this.removeFromLookup(aPrecedingPosition);
        if (thePrevPlayerPos != aPlayer) {
            throw new IllegalStateException("Illegal state detected while moving player \"" + aPlayer + "> from position (" + aPrecedingPosition.toString() + "): The previous position contains the wrong player \"" + thePrevPlayerPos + "> instead of the expected player \"" + aPlayer + "\". Probably some thread race condition and insufficient synchronization.");
        }
        return theReplacedPlayer;
    }

    private int toTopYPosition(Position aPos) {
        int y = aPos.getPositionY() - 1;
        if (y < 0) {
            if (this.getGridMode() == GridMode.PERIODIC) {
                y = this.getGridHeight() - 1;
            } else {
                throw new IndexOutOfBoundsException("As the grid is in mode <" + this.getGridMode() + "> an index of <" + aPos.toString() + "> is out of bounds!");
            }
        }
        return y;
    }

    private int toRightXPosition(Position aPos) {
        int x = aPos.getPositionX() + 1;
        if (x > this.getGridWidth() - 1) {
            if (this.getGridMode() == GridMode.PERIODIC) {
                x = 0;
            } else {
                throw new IndexOutOfBoundsException("As the grid is in mode <" + this.getGridMode() + "> an index of <" + aPos.toString() + "> is out of bounds!");
            }
        }
        return x;
    }

    private int toBottomYPosition(Position aPos) {
        int y = aPos.getPositionY() + 1;
        if (y > this.getGridHeight() - 1) {
            if (this.getGridMode() == GridMode.PERIODIC) {
                y = 0;
            } else {
                throw new IndexOutOfBoundsException("As the grid is in mode <" + this.getGridMode() + "> an index of <" + aPos.toString() + "> is out of bounds!");
            }
        }
        return y;
    }

    private int toLeftXPosition(Position aPos) {
        int x = aPos.getPositionX() - 1;
        if (x < 0) {
            if (this.getGridMode() == GridMode.PERIODIC) {
                x = this.getGridWidth() - 1;
            } else {
                throw new IndexOutOfBoundsException("As the grid is in mode <" + this.getGridMode() + "> an index of <" + aPos.toString() + "> is out of bounds!");
            }
        }
        return x;
    }

    private class CheckerboardPlayerObserverImpl
    implements PlayerObserver<P, S> {
        private CheckerboardPlayerObserverImpl() {
        }

        @Override
        public void onPlayerEvent(PlayerEvent<P> aPlayerEvent) {
            try {
                AbstractCheckerboard.this.fireEvent(aPlayerEvent, ExecutionStrategy.SEQUENTIAL);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }

        @Override
        public void onChangePlayerPositionEvent(ChangePlayerPositionEvent<P> aPlayerEvent) throws VetoException {
            try {
                AbstractCheckerboard.this.fireEvent(aPlayerEvent, ExecutionStrategy.SEQUENTIAL);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }

        @Override
        public void onPlayerPositionChangedEvent(PlayerPositionChangedEvent<P> aPlayerEvent) {
            Object thePlayer = aPlayerEvent.getSource();
            Position thePrecedingPosition = aPlayerEvent.getPrecedingPosition();
            AbstractCheckerboard.this.updatePlayer(thePlayer, thePrecedingPosition);
            try {
                AbstractCheckerboard.this.fireEvent(aPlayerEvent, ExecutionStrategy.SEQUENTIAL);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }

        @Override
        public void onPlayerStateChangedEvent(PlayerStateChangedEvent<P, S> aPlayerEvent) {
            try {
                AbstractCheckerboard.this.fireEvent(aPlayerEvent, ExecutionStrategy.SEQUENTIAL);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }

        @Override
        public void onPlayerVisibilityChangedEvent(PlayerVisibilityChangedEvent<P> aPlayerEvent) {
            try {
                AbstractCheckerboard.this.fireEvent(aPlayerEvent, ExecutionStrategy.SEQUENTIAL);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }

        @Override
        public void onPlayerDraggabilityChangedEvent(PlayerDraggabilityChangedEvent<P> aPlayerEvent) {
            try {
                AbstractCheckerboard.this.fireEvent(aPlayerEvent, ExecutionStrategy.SEQUENTIAL);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }
}

