/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.CheckerboardViewer;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.SpriteFactory;
import org.refcodes.checkerboard.ViewportOffsetChangedEvent;
import org.refcodes.component.InitializeException;
import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.Offset;
import org.refcodes.graphical.Position;
import org.refcodes.graphical.ViewportDimension;
import org.refcodes.graphical.ViewportDimensionPropertyBuilder;
import org.refcodes.graphical.ViewportOffset;
import org.refcodes.observer.SubscribeEvent;
import org.refcodes.observer.UnsubscribeEvent;

public abstract class AbstractCheckerboardViewer<P extends Player<P, S>, S, IMG, SF extends SpriteFactory<IMG, S, ?>, CBV extends CheckerboardViewer<P, S, CBV>>
implements CheckerboardViewer<P, S, CBV> {
    private int _viewportWidth = -1;
    private int _viewportHeight = -1;
    private int _viewportOffsetX = 0;
    private int _viewportOffsetY = 0;
    private final ViewportDimensionPropertyBuilder _minViewportDimension = new ViewportDimensionPropertyBuilder(-1, -1);
    protected Checkerboard<P, S> _checkerboard;

    public AbstractCheckerboardViewer(Checkerboard<P, S> aCheckerboard) {
        this._checkerboard = aCheckerboard;
    }

    public CBV withInitialize() throws InitializeException {
        this.initialize();
        return (CBV)this;
    }

    public CBV withViewportOffsetY(int aPosY) {
        this.setViewportOffsetY(aPosY);
        return (CBV)this;
    }

    public CBV withViewportHeight(int aGridHeight) {
        this.setViewportHeight(aGridHeight);
        return (CBV)this;
    }

    public CBV withViewportWidth(int aGridWidth) {
        this.setViewportWidth(aGridWidth);
        return (CBV)this;
    }

    public CBV withViewportDimension(int aWidth, int aHeight) {
        this.setViewportDimension(aWidth, aHeight);
        return (CBV)this;
    }

    public CBV withViewportDimension(ViewportDimension aGridDimension) {
        this.setViewportDimension(aGridDimension);
        return (CBV)this;
    }

    public CBV withViewportDimension(Dimension aDimension) {
        this.setViewportDimension(aDimension);
        return (CBV)this;
    }

    public CBV withViewportOffset(int aPosX, int aPosY) {
        this.setViewportOffset(aPosX, aPosY);
        return (CBV)this;
    }

    public CBV withViewportOffset(Position aOffset) {
        this.setViewportOffset(aOffset);
        return (CBV)this;
    }

    public CBV withViewportOffset(ViewportOffset aOffset) {
        this.setViewportOffset(aOffset);
        return (CBV)this;
    }

    public CBV withViewportOffset(Offset aOffset) {
        this.setViewportOffset(aOffset);
        return (CBV)this;
    }

    public CBV withViewportOffsetX(int aPosX) {
        this.setViewportOffsetX(aPosX);
        return (CBV)this;
    }

    public CBV withMinViewportDimension(ViewportDimension aDimension) {
        this.setMinViewportDimension(aDimension);
        return (CBV)this;
    }

    public CBV withMinViewportDimension(int aWidth, int aHeight) {
        this.setMinViewportDimension(aWidth, aHeight);
        return (CBV)this;
    }

    public void setViewportDimension(int aWidth, int aHeight) {
        if (this._minViewportDimension.getViewportWidth() != -1 && aWidth < this._minViewportDimension.getViewportWidth()) {
            throw new IllegalArgumentException("The provided grid width <" + aWidth + "> is less than the min grid width (<" + this._minViewportDimension.getViewportWidth() + ">).");
        }
        if (this._minViewportDimension.getViewportHeight() != -1 && aHeight < this._minViewportDimension.getViewportHeight()) {
            throw new IllegalArgumentException("The provided grid height <" + aHeight + "> is less than the min grid height (<" + this._minViewportDimension.getViewportHeight() + ">).");
        }
        this._viewportWidth = aWidth;
        this._viewportHeight = aHeight;
    }

    public void setViewportDimension(ViewportDimension aGridDimension) {
        this.setViewportDimension(aGridDimension.getViewportWidth(), aGridDimension.getViewportHeight());
    }

    public void setViewportDimension(Dimension aDimension) {
        this.setViewportDimension(aDimension.getWidth(), aDimension.getHeight());
    }

    public void setViewportWidth(int aGridWidth) {
        this.setViewportDimension(aGridWidth, this._viewportHeight);
    }

    public void setViewportHeight(int aGridHeight) {
        this.setViewportDimension(this._viewportWidth, aGridHeight);
    }

    public int getViewportWidth() {
        return this._viewportWidth;
    }

    public int getViewportHeight() {
        return this._viewportHeight;
    }

    public void setViewportOffset(int aPosX, int aPosY) {
        if (aPosX != this._viewportOffsetX || aPosY != this._viewportOffsetY) {
            ViewportOffsetChangedEvent theEvent = new ViewportOffsetChangedEvent(aPosX, aPosY, this._viewportOffsetX, this._viewportOffsetY, this);
            this._viewportOffsetX = aPosX;
            this._viewportOffsetY = aPosY;
            this.onViewportOffsetChangedEvent(theEvent);
        }
    }

    public void setViewportOffset(Position aOffset) {
        this.setViewportOffset(aOffset.getPositionX(), aOffset.getPositionY());
    }

    public void setViewportOffset(ViewportOffset aOffset) {
        this.setViewportOffset(aOffset.getViewportOffsetX(), aOffset.getViewportOffsetY());
    }

    public void setViewportOffset(Offset aOffset) {
        this.setViewportOffset(aOffset.getOffsetX(), aOffset.getOffsetY());
    }

    public void setViewportOffsetX(int aPosX) {
        this.setViewportOffset(aPosX, this._viewportOffsetY);
    }

    public int getViewportOffsetX() {
        return this._viewportOffsetX;
    }

    public int getViewportOffsetY() {
        return this._viewportOffsetY;
    }

    public void setViewportOffsetY(int aPosY) {
        this.setViewportOffset(this._viewportOffsetX, aPosY);
    }

    public void setMinViewportDimension(ViewportDimension aDimension) {
        this._minViewportDimension.setViewportDimension(aDimension);
    }

    public ViewportDimension getMinViewportDimension() {
        return this._minViewportDimension;
    }

    public void setMinViewportDimension(int aWidth, int aHeight) {
        this._minViewportDimension.setViewportDimension(aWidth, aHeight);
    }

    public void setMinViewportDimension(Dimension aDimension) {
        this._minViewportDimension.setViewportDimension(aDimension);
    }

    public CBV withMinViewportDimension(Dimension aDimension) {
        this.setMinViewportDimension(aDimension);
        return (CBV)this;
    }

    @Override
    public void centerViewortOffset(int aPositionX, int aPositionY) {
        this.centerViewortOffset(aPositionX, aPositionY, this.getViewportWidth(), this.getViewportHeight());
    }

    @Override
    public void centerViewortOffset(int aPositionX, int aPositionY, int aViewportWidth, int aViewportHeight) {
        int theGridWidth = this.getGridWidth();
        int theGridHeight = this._checkerboard.getGridHeight();
        int theOffsetX = aPositionX - aViewportWidth / 2;
        int theOffsetY = aPositionY - aViewportHeight / 2;
        if (theOffsetX > theGridWidth - aViewportWidth) {
            theOffsetX = theGridWidth - aViewportWidth;
        }
        if (theOffsetY > theGridHeight - aViewportHeight) {
            theOffsetY = theGridHeight - aViewportHeight;
        }
        if (theOffsetX < 0) {
            theOffsetX = 0;
        }
        if (theOffsetY < 0) {
            theOffsetY = 0;
        }
        this.setViewportOffset(-theOffsetX, -theOffsetY);
    }

    public GridMode getGridMode() {
        return this._checkerboard.getGridMode();
    }

    public int getGridWidth() {
        return this._checkerboard.getGridWidth();
    }

    public int getGridHeight() {
        return this._checkerboard.getGridHeight();
    }

    public void destroy() {
        this._checkerboard.destroy();
    }

    public void onSubscribe(SubscribeEvent<Checkerboard<P, S>> aSubscribeEvent) {
        this._checkerboard = (Checkerboard)aSubscribeEvent.getSource();
    }

    public void onUnsubscribe(UnsubscribeEvent<Checkerboard<P, S>> aUnsubscribeEvent) {
    }
}

