/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.ChangePlayerPositionEvent;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.PlayerClickedEvent;
import org.refcodes.checkerboard.PlayerDraggabilityChangedEvent;
import org.refcodes.checkerboard.PlayerEvent;
import org.refcodes.checkerboard.PlayerObserver;
import org.refcodes.checkerboard.PlayerPositionChangedEvent;
import org.refcodes.checkerboard.PlayerStateChangedEvent;
import org.refcodes.checkerboard.PlayerVisibilityChangedEvent;
import org.refcodes.controlflow.ExecutionStrategy;
import org.refcodes.exception.VetoException;
import org.refcodes.graphical.Position;
import org.refcodes.observer.AbstractObservable;

public abstract class AbstractPlayer<P extends Player<P, S>, S>
extends AbstractObservable<PlayerObserver<P, S>, PlayerEvent<P>>
implements Player<P, S> {
    private static final ExecutionStrategy STRATEGY = ExecutionStrategy.SEQUENTIAL;
    private int _posX;
    private int _posY;
    private S _state;
    private boolean _isVisible = true;
    private boolean _isDraggable = true;

    public AbstractPlayer() {
    }

    public AbstractPlayer(int aPosX, int aPosY) {
        this._posX = aPosX;
        this._posY = aPosY;
    }

    public AbstractPlayer(Position aPosition) {
        this._posX = aPosition.getPositionX();
        this._posY = aPosition.getPositionY();
    }

    @Override
    public void click() {
        try {
            PlayerClickedEvent<AbstractPlayer> theEvent = new PlayerClickedEvent<AbstractPlayer>(this);
            this.fireEvent(theEvent, STRATEGY);
        }
        catch (VetoException vetoException) {
            // empty catch block
        }
    }

    public P withPosition(int aPosX, int aPosY) {
        this.setPosition(aPosX, aPosY);
        return (P)this;
    }

    public P withPosition(Position aPosition) {
        this.setPosition(aPosition);
        return (P)this;
    }

    public void setPosition(int aPosX, int aPosY) {
        if (aPosX != this._posX || aPosY != this._posY) {
            ChangePlayerPositionEvent<AbstractPlayer> theVetoable = new ChangePlayerPositionEvent<AbstractPlayer>(aPosX, aPosY, this._posX, this._posY, this);
            try {
                this.fireEvent(theVetoable, STRATEGY);
            }
            catch (VetoException e) {
                throw new VetoException.VetoRuntimeException(e.getMessage(), (Throwable)e);
            }
            PlayerPositionChangedEvent<AbstractPlayer> theEvent = new PlayerPositionChangedEvent<AbstractPlayer>(aPosX, aPosY, this._posX, this._posY, this);
            this._posX = aPosX;
            this._posY = aPosY;
            try {
                this.fireEvent(theEvent, STRATEGY);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    public void setPosition(Position aPosition) {
        this.setPosition(aPosition.getPositionX(), aPosition.getPositionY());
    }

    public P withPositionY(int aPosY) {
        this.setPositionY(aPosY);
        return (P)this;
    }

    public void setPositionY(int aPosY) {
        if (aPosY != this._posY) {
            PlayerPositionChangedEvent<AbstractPlayer> theEvent = new PlayerPositionChangedEvent<AbstractPlayer>(this._posX, aPosY, this._posX, this._posY, this);
            this._posY = aPosY;
            try {
                this.fireEvent(theEvent, STRATEGY);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    public P withPositionX(int aPosX) {
        this.setPositionX(aPosX);
        return (P)this;
    }

    public void setStatus(S aState) {
        if (aState != this._state) {
            PlayerStateChangedEvent<AbstractPlayer, S> theEvent = new PlayerStateChangedEvent<AbstractPlayer, S>(aState, this._state, this);
            this._state = aState;
            try {
                this.fireEvent(theEvent, STRATEGY);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    public P withStatus(S aState) {
        this.setStatus(aState);
        return (P)this;
    }

    public void setPositionX(int aPosX) {
        if (aPosX != this._posX) {
            PlayerPositionChangedEvent<AbstractPlayer> theEvent = new PlayerPositionChangedEvent<AbstractPlayer>(aPosX, this._posY, this._posX, this._posY, this);
            this._posX = aPosX;
            try {
                this.fireEvent(theEvent, STRATEGY);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    public void setVisible(boolean isVisible) {
        if (isVisible != this._isVisible) {
            PlayerVisibilityChangedEvent<AbstractPlayer> theEvent = new PlayerVisibilityChangedEvent<AbstractPlayer>(this);
            this._isVisible = isVisible;
            try {
                this.fireEvent(theEvent, STRATEGY);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    public P withShow() {
        this.setVisible(true);
        return (P)this;
    }

    public P withHide() {
        this.setVisible(false);
        return (P)this;
    }

    public P withVisible(boolean isVisible) {
        this.setVisible(isVisible);
        return (P)this;
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public void setDraggable(boolean isDraggable) {
        if (isDraggable != this._isDraggable) {
            PlayerDraggabilityChangedEvent<AbstractPlayer> theEvent = new PlayerDraggabilityChangedEvent<AbstractPlayer>(this);
            this._isDraggable = isDraggable;
            try {
                this.fireEvent(theEvent, STRATEGY);
            }
            catch (VetoException vetoException) {
                // empty catch block
            }
        }
    }

    public P withDraggable() {
        this.setDraggable(true);
        return (P)this;
    }

    public P withStationary() {
        this.setDraggable(false);
        return (P)this;
    }

    public P withDraggable(boolean isDraggable) {
        this.setDraggable(isDraggable);
        return (P)this;
    }

    public void draggable() {
        this.setDraggable(true);
    }

    public void stationary() {
        this.setDraggable(false);
    }

    public boolean isDraggable() {
        return this._isDraggable;
    }

    public int getPositionX() {
        return this._posX;
    }

    public int getPositionY() {
        return this._posY;
    }

    public S getStatus() {
        return this._state;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this._posX + ":" + this._posY + ", " + this.getStatus() + ")@" + this.hashCode();
    }

    protected boolean fireEvent(PlayerEvent<P> aEvent, PlayerObserver<P, S> aObserver, ExecutionStrategy aExecutionStrategy) throws VetoException {
        aObserver.onPlayerEvent(aEvent);
        if (aEvent instanceof ChangePlayerPositionEvent) {
            aObserver.onChangePlayerPositionEvent((ChangePlayerPositionEvent)aEvent);
        }
        if (aEvent instanceof PlayerPositionChangedEvent) {
            aObserver.onPlayerPositionChangedEvent((PlayerPositionChangedEvent)aEvent);
        }
        if (aEvent instanceof PlayerClickedEvent) {
            aObserver.onPlayerClickedEvent((PlayerClickedEvent)aEvent);
        }
        if (aEvent instanceof PlayerStateChangedEvent) {
            aObserver.onPlayerStateChangedEvent((PlayerStateChangedEvent)aEvent);
        }
        if (aEvent instanceof PlayerVisibilityChangedEvent) {
            aObserver.onPlayerVisibilityChangedEvent((PlayerVisibilityChangedEvent)aEvent);
        }
        if (aEvent instanceof PlayerDraggabilityChangedEvent) {
            aObserver.onPlayerDraggabilityChangedEvent((PlayerDraggabilityChangedEvent)aEvent);
        }
        return true;
    }
}

