/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.CheckerboardObserver;
import org.refcodes.checkerboard.Player;
import org.refcodes.component.Initializable;
import org.refcodes.component.InitializableComponent;
import org.refcodes.graphical.GridDimension;
import org.refcodes.graphical.GridModeAccessor;
import org.refcodes.graphical.MinViewportDimension;
import org.refcodes.graphical.Viewport;
import org.refcodes.graphical.ViewportDimension;
import org.refcodes.graphical.ViewportOffset;
import org.refcodes.graphical.ViewportWidthAccessor;

public interface CheckerboardViewer<P extends Player<P, S>, S, CBV extends CheckerboardViewer<P, S, CBV>>
extends CheckerboardObserver<P, S>,
Viewport,
ViewportDimension.ViewportDimensionProperty,
ViewportDimension.ViewportDimensionBuilder<CBV>,
MinViewportDimension.MinViewportDimensionProperty,
MinViewportDimension.MinViewportDimensionBuilder<CBV>,
ViewportWidthAccessor.ViewportWidthProperty,
ViewportWidthAccessor.ViewportWidthBuilder<CBV>,
ViewportOffset.ViewportOffsetProperty,
ViewportOffset.ViewportOffsetBuilder<CBV>,
GridDimension,
GridModeAccessor,
InitializableComponent,
Initializable.InitializeBuilder<CBV> {
    default public void centerViewortOffset(int aPositionX, int aPositionY) {
        this.centerViewortOffset(aPositionX, aPositionY, this.getViewportWidth(), this.getViewportHeight());
    }

    default public void centerViewortOffset(int aPositionX, int aPositionY, int aViewportWidth, int aViewportHeight) {
        int theGridWidth = this.getGridWidth();
        int theGridHeight = this.getGridHeight();
        int theOffsetX = aPositionX - aViewportWidth / 2;
        int theOffsetY = aPositionY - aViewportHeight / 2;
        if (theOffsetX > theGridWidth - aViewportWidth) {
            theOffsetX = theGridWidth - aViewportWidth;
        }
        if (theOffsetY > theGridHeight - aViewportHeight) {
            theOffsetY = theGridHeight - aViewportHeight;
        }
        if (theOffsetX < 0) {
            theOffsetX = 0;
        }
        if (theOffsetY < 0) {
            theOffsetY = 0;
        }
        this.setViewportOffset(-theOffsetX, -theOffsetY);
    }
}

