/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.AbstractCheckerboardViewer;
import org.refcodes.checkerboard.ChangePlayerPositionEvent;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.CheckerboardEvent;
import org.refcodes.checkerboard.ConsoleSpriteFactory;
import org.refcodes.checkerboard.GridDimensionChangedEvent;
import org.refcodes.checkerboard.GridModeChangedEvent;
import org.refcodes.checkerboard.GridPositionClickedEvent;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.PlayerAddedEvent;
import org.refcodes.checkerboard.PlayerDraggabilityChangedEvent;
import org.refcodes.checkerboard.PlayerEvent;
import org.refcodes.checkerboard.PlayerPositionChangedEvent;
import org.refcodes.checkerboard.PlayerRemovedEvent;
import org.refcodes.checkerboard.PlayerStateChangedEvent;
import org.refcodes.checkerboard.PlayerVisibilityChangedEvent;
import org.refcodes.checkerboard.ViewportDimensionChangedEvent;
import org.refcodes.checkerboard.ViewportOffsetChangedEvent;
import org.refcodes.component.InitializeException;
import org.refcodes.exception.VetoException;
import org.refcodes.mixin.ColumnWidthAccessor;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableStyle;

public class ConsoleCheckerboardViewer<P extends Player<P, S>, S>
extends AbstractCheckerboardViewer<P, S, String, ConsoleSpriteFactory<S>, ConsoleCheckerboardViewer<P, S>>
implements ColumnWidthAccessor.ColumnWidthProperty,
ColumnWidthAccessor.ColumnWidthBuilder<ConsoleCheckerboardViewer<P, S>> {
    private static final int DEFAULT_REFRESH_LOOP_TIME_MILLIS = 100;
    private static final int DEFAULT_COLUMN_WIDTH = 3;
    private ConsoleSpriteFactory<S> _spriteFactory;
    private int _redrawLoopTimeMillis;
    private int _oldState = -1;
    private int _columnWidth;

    public ConsoleCheckerboardViewer(Checkerboard<P, S> aCheckerboard, ConsoleSpriteFactory<S> aSpriteFactory) {
        this(aCheckerboard, aSpriteFactory, 100);
    }

    public ConsoleCheckerboardViewer(Checkerboard<P, S> aCheckerboard, ConsoleSpriteFactory<S> aSpriteFactory, int aRedrawLoopTimeMillis) {
        this(aCheckerboard, aSpriteFactory, 3, aRedrawLoopTimeMillis);
    }

    public ConsoleCheckerboardViewer(Checkerboard<P, S> aCheckerboard, ConsoleSpriteFactory<S> aSpriteFactory, int aColumnWidth, int aRedrawLoopTimeMillis) {
        super(aCheckerboard);
        aCheckerboard.subscribeObserver(this);
        this._spriteFactory = aSpriteFactory;
        this._redrawLoopTimeMillis = aRedrawLoopTimeMillis;
        this._columnWidth = aColumnWidth;
    }

    public void initialize() throws InitializeException {
        if (this._redrawLoopTimeMillis > 0) {
            Thread t = new Thread(this::printPlaygroundDaemon);
            t.setDaemon(true);
            t.start();
        }
    }

    @Override
    public synchronized void onCheckerboardEvent(CheckerboardEvent<P, S> aCheckerboardEvent) {
        this.onEventPrintPlayground();
    }

    @Override
    public void onPlayerAddedEvent(PlayerAddedEvent<P, S> aCheckerboardEvent) {
    }

    @Override
    public void onPlayerRemovedEvent(PlayerRemovedEvent<P, S> aCheckerboardEvent) {
    }

    @Override
    public void onGridModeChangedEvent(GridModeChangedEvent<P, S> aCheckerboardEvent) {
    }

    @Override
    public void onGridDimensionChangedEvent(GridDimensionChangedEvent<P, S> aCheckerboardEvent) {
    }

    @Override
    public void onViewportOffsetChangedEvent(ViewportOffsetChangedEvent<P, S> aCheckerboardEvent) {
    }

    @Override
    public void onViewportDimensionChangedEvent(ViewportDimensionChangedEvent<P, S> aCheckerboardEvent) {
    }

    @Override
    public void onGridPositionClickedEvent(GridPositionClickedEvent<P, S> aEvent) {
    }

    @Override
    public synchronized void onPlayerEvent(PlayerEvent<P> aPlayerEvent, Checkerboard<P, S> aSource) {
        this.onEventPrintPlayground();
    }

    @Override
    public void onChangePlayerPositionEvent(ChangePlayerPositionEvent<P> aPlayerEvent, Checkerboard<P, S> aSource) throws VetoException {
    }

    @Override
    public void onPlayerPositionChangedEvent(PlayerPositionChangedEvent<P> aPlayerEvent, Checkerboard<P, S> aSource) {
    }

    @Override
    public synchronized void onPlayerStateChangedEvent(PlayerStateChangedEvent<P, S> aPlayerEvent, Checkerboard<P, S> aSource) {
        this.onEventPrintPlayground();
    }

    @Override
    public void onPlayerVisibilityChangedEvent(PlayerVisibilityChangedEvent<P> aPlayerEvent, Checkerboard<P, S> aSource) {
    }

    @Override
    public void onPlayerDraggabilityChangedEvent(PlayerDraggabilityChangedEvent<P> aPlayerEvent, Checkerboard<P, S> aSource) {
    }

    public int getRedrawLoopTimeMillis() {
        return this._redrawLoopTimeMillis;
    }

    public boolean isRedrawOnEvent() {
        return this._redrawLoopTimeMillis <= 0;
    }

    protected void printPlaygroundDaemon() {
        while (true) {
            this.printPlayground();
            try {
                Thread.sleep(this._redrawLoopTimeMillis);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    protected void onEventPrintPlayground() {
        if (this._redrawLoopTimeMillis <= 0) {
            this.printPlayground();
        }
    }

    private synchronized void printPlayground() {
        if (this._oldState != this.toState(this._checkerboard)) {
            int the1stWidth = Integer.toString(this._checkerboard.getGridHeight()).length() + 2;
            TableBuilder theBuilder = new TableBuilder().withTableStyle(TableStyle.SINGLE_HEADER_SINGLE_BODY).withRowWidth(-1);
            theBuilder.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.CENTER).withColumnWidth(the1stWidth);
            int x = 0;
            while (x < this.getGridWidth()) {
                theBuilder.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.CENTER).withColumnWidth(this._columnWidth);
                ++x;
            }
            String[] theRows = new String[this.getGridWidth() + 1];
            theRows[0] = "";
            int x2 = 0;
            while (x2 < this.getGridWidth()) {
                theRows[x2 + 1] = Integer.toString(x2);
                ++x2;
            }
            theBuilder.printHeader(theRows);
            String[] theColumns = new String[this.getGridWidth() + 1];
            int y = 0;
            while (y < this.getGridHeight()) {
                theColumns[0] = "" + Character.valueOf((char)(97 + y));
                int x3 = 0;
                while (x3 < this.getGridWidth()) {
                    Object ePlayer = this._checkerboard.atPosition(x3, y);
                    theColumns[x3 + 1] = ePlayer != null ? (String)this._spriteFactory.create(ePlayer.getStatus(), this) : "";
                    ++x3;
                }
                theBuilder.printRow(theColumns);
                ++y;
            }
            theBuilder.printTail();
            System.out.println();
            this._oldState = this.toState(this._checkerboard);
        }
    }

    private int toState(Checkerboard<P, S> aCheckerboard) {
        StringBuilder theBuilder = new StringBuilder();
        for (Player ePlayer : this._checkerboard.getPlayers()) {
            theBuilder.append(ePlayer.getPositionX());
            theBuilder.append(ePlayer.getPositionY());
            theBuilder.append(ePlayer.getStatus());
            if (ePlayer.getStatus() == null) continue;
            theBuilder.append(ePlayer.getStatus().hashCode());
        }
        return theBuilder.toString().hashCode();
    }

    public int getColumnWidth() {
        return this._columnWidth;
    }

    public void setColumnWidth(int aColumnWidth) {
        this._columnWidth = aColumnWidth;
    }

    public ConsoleCheckerboardViewer<P, S> withColumnWidth(int aColumnWidth) {
        this.setColumnWidth(aColumnWidth);
        return this;
    }
}

